/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOInputHandler;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.InputHandler;
import org.apache.fop.apps.XSLTInputHandler;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.awt.AWTRenderer;
import org.apache.fop.viewer.SecureResourceBundle;
import org.apache.fop.viewer.Translator;
import org.xml.sax.XMLReader;
import pcgen.core.Constants;
import pcgen.util.Logging;

public final class FOPHandler
implements Runnable {
    public static final int PDF_MODE = 0;
    public static final int AWT_MODE = 1;
    private Driver driver = new Driver();
    private File outFile = null;
    private FileOutputStream fos;
    private InputHandler inputHandler = null;
    private Renderer renderer = null;
    private StringBuffer errBuffer = new StringBuffer();
    private int mode = 0;

    public String getErrorMessage() {
        return this.errBuffer.toString();
    }

    public void setInputFile(File file) {
        try {
            if (file == null) {
                throw new NullPointerException("XML file must be specified for the tranform mode");
            }
            if (!file.exists()) {
                throw new FileNotFoundException("xml file " + file.getAbsolutePath() + " not found ");
            }
            this.inputHandler = new FOInputHandler(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.errBuffer.append(fileNotFoundException.getMessage()).append(Constants.s_LINE_SEP);
            Logging.errorPrint("Exception in FOPHandler:setInputFile", fileNotFoundException);
        }
    }

    public void setInputFile(File file, File file2) {
        try {
            if (file == null) {
                throw new NullPointerException("XML file must be specified for the tranform mode");
            }
            if (file2 == null) {
                throw new NullPointerException("XSLT file must be specified for the tranform mode");
            }
            if (!file.exists()) {
                throw new FileNotFoundException("xml file " + file.getAbsolutePath() + " not found ");
            }
            if (!file2.exists()) {
                throw new FileNotFoundException("xsl file " + file2.getAbsolutePath() + " not found ");
            }
            this.inputHandler = new XSLTInputHandler(file, file2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.errBuffer.append(fileNotFoundException.getMessage()).append(Constants.s_LINE_SEP);
            Logging.errorPrint("Exception in FOPHandler:setInputFile", fileNotFoundException);
        }
        catch (NullPointerException nullPointerException) {
            this.errBuffer.append(nullPointerException.getMessage()).append(Constants.s_LINE_SEP);
            Logging.errorPrint("Exception in FOPHandler:setInputFile", nullPointerException);
        }
        catch (FOPException fOPException) {
            this.errBuffer.append(fOPException.getMessage()).append(Constants.s_LINE_SEP);
            Logging.errorPrint("Exception in FOPHandler:setInputFile", fOPException);
        }
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public void setOutputFile(File file) {
        this.outFile = file;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.errBuffer.delete(0, this.errBuffer.length());
        this.driver.reset();
        if (this.mode == 0) {
            this.fos = null;
            this.renderer = null;
            this.driver.setRenderer(1);
            try {
                XMLReader xMLReader = this.inputHandler.getParser();
                HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
                hashMap.put("fineDetail", false);
                this.driver.getRenderer().setOptions(hashMap);
                this.driver.getRenderer().setProducer("PC Gen Character Generator");
                this.fos = new FileOutputStream(this.outFile);
                this.driver.setOutputStream((OutputStream)this.fos);
                this.driver.render(xMLReader, this.inputHandler.getInputSource());
            }
            catch (FOPException fOPException) {
                this.errBuffer.append(fOPException.getMessage()).append(Constants.s_LINE_SEP);
                Logging.errorPrint("Exception in FOPHandler:run", fOPException);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.errBuffer.append(fileNotFoundException.getMessage()).append(Constants.s_LINE_SEP);
                Logging.errorPrint("Exception in FOPHandler:run, cannot find file: " + fileNotFoundException.getMessage());
            }
            finally {
                if (this.fos != null) {
                    try {
                        this.fos.close();
                    }
                    catch (IOException iOException) {
                        this.errBuffer.append(iOException.getMessage()).append(Constants.s_LINE_SEP);
                        Logging.errorPrint("Exception in FOPHandler:run", iOException);
                    }
                }
            }
        } else if (this.mode == 1) {
            this.renderer = FOPHandler.createAWTRenderer();
            this.driver.setRenderer(this.renderer);
            try {
                XMLReader xMLReader = this.inputHandler.getParser();
                this.driver.render(xMLReader, this.inputHandler.getInputSource());
            }
            catch (FOPException fOPException) {
                this.errBuffer.append(fOPException.getMessage()).append(Constants.s_LINE_SEP);
                Logging.errorPrint("Exception in FOPHandler:run", fOPException);
            }
        } else {
            Logging.errorPrint("Unsupported mode for file export.");
        }
    }

    private static AWTRenderer createAWTRenderer() {
        byte[] byArray = new byte[]{};
        return new AWTRenderer((Translator)new SecureResourceBundle((InputStream)new ByteArrayInputStream(byArray)));
    }
}

