/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import pcgen.core.Globals;
import pcgen.util.WeightedSubList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightedList<E>
implements List<E> {
    protected List<WeightedItem<E>> theData;

    public WeightedList() {
        this.theData = new ArrayList<WeightedItem<E>>();
    }

    public WeightedList(int n) {
        this.theData = new ArrayList<WeightedItem<E>>(n);
    }

    public WeightedList(WeightedList<E> weightedList) {
        if (weightedList == null) {
            this.theData = new ArrayList<WeightedItem<E>>();
        } else {
            this.theData = new ArrayList<WeightedItem<E>>(weightedList.theData.size());
            for (WeightedItem<E> weightedItem : weightedList.theData) {
                this.theData.add(new WeightedItem<E>(weightedItem.getElement(), weightedItem.getWeight()));
            }
        }
    }

    public WeightedList(Collection<? extends E> collection) {
        this.theData = new ArrayList<WeightedItem<E>>(collection.size());
        for (E e : collection) {
            this.add(e);
        }
    }

    @Override
    public int size() {
        return this.totalWeight();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        int n = this.theData.size();
        for (E e : collection) {
            this.add(e);
        }
        return this.theData.size() != n;
    }

    @Override
    public void add(int n, E e) {
        for (WeightedItem<E> weightedItem : this.theData) {
            if (!weightedItem.getElement().equals(e)) continue;
            weightedItem.addWeight(n);
            return;
        }
        this.theData.add(new WeightedItem<E>(e, n));
    }

    @Override
    public boolean add(E e) {
        this.add(1, e);
        return true;
    }

    @Override
    public E get(int n) {
        int n2 = 0;
        for (int i = 0; i < this.theData.size(); ++i) {
            WeightedItem<E> weightedItem = this.theData.get(i);
            if ((n2 += weightedItem.getWeight()) <= n) continue;
            return weightedItem.getElement();
        }
        return null;
    }

    public E getRandomValue() {
        return this.get(Globals.getRandomInt(this.size()));
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public boolean contains(Object object) {
        for (E e : this) {
            if (!(e instanceof List ? ((List)e).contains(object) : e.equals(object))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object object) {
        Iterator<WeightedItem<E>> iterator = this.theData.iterator();
        while (iterator.hasNext()) {
            WeightedItem<E> weightedItem = iterator.next();
            if (!weightedItem.getElement().equals(object)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.theData.isEmpty();
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.theData.size()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.theData.get(i).getElement();
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        if (objectArray.length < this.theData.size()) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.theData.size());
        }
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.theData.get(i).getElement();
        }
        if (objectArray.length > this.theData.size()) {
            objectArray[this.theData.size()] = null;
        }
        return objectArray;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.theData.containsAll(collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.theData.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.theData.retainAll(collection);
    }

    @Override
    public void clear() {
        this.theData.clear();
    }

    @Override
    public boolean equals(Object object) {
        return ((Object)this.theData).equals(object);
    }

    @Override
    public int hashCode() {
        return ((Object)this.theData).hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        Iterator<WeightedItem<E>> iterator = this.theData.iterator();
        boolean bl = iterator.hasNext();
        while (bl) {
            WeightedItem<E> weightedItem = iterator.next();
            E e = weightedItem.getElement();
            stringBuffer.append(e == this ? "(this list)" : String.valueOf(e));
            stringBuffer.append(" (").append(weightedItem.getWeight()).append(")");
            bl = iterator.hasNext();
            if (!bl) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        int n2 = this.theData.size();
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(n, iterator.next());
        }
        return this.theData.size() != n2;
    }

    @Override
    public E set(int n, E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int n) {
        WeightedItem<E> weightedItem = this.theData.remove(n);
        if (weightedItem != null) {
            return weightedItem.getElement();
        }
        return null;
    }

    @Override
    public int indexOf(Object object) {
        return this.theData.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.theData.lastIndexOf(object);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListItr();
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        return new ListItr(n);
    }

    @Override
    public List<E> subList(int n, int n2) {
        return new WeightedSubList(this, n, n2);
    }

    private int totalWeight() {
        int n = 0;
        for (int i = 0; i < this.theData.size(); ++i) {
            WeightedItem<E> weightedItem = this.theData.get(i);
            n += weightedItem.getWeight();
        }
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListItr
    implements ListIterator<E> {
        ListIterator<WeightedItem<E>> realIterator = null;

        public ListItr() {
            this.realIterator = WeightedList.this.theData.listIterator();
        }

        public ListItr(int n) {
            this.realIterator = WeightedList.this.theData.listIterator(n);
        }

        @Override
        public boolean hasNext() {
            return this.realIterator.hasNext();
        }

        @Override
        public E next() {
            WeightedItem weightedItem = this.realIterator.next();
            return weightedItem.getElement();
        }

        @Override
        public boolean hasPrevious() {
            return this.realIterator.hasPrevious();
        }

        @Override
        public E previous() {
            WeightedItem weightedItem = this.realIterator.previous();
            return weightedItem.getElement();
        }

        @Override
        public int nextIndex() {
            return this.realIterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.realIterator.previousIndex();
        }

        @Override
        public void remove() {
            this.realIterator.remove();
        }

        @Override
        public void set(E e) {
            WeightedItem weightedItem = new WeightedItem(e, 1);
            this.realIterator.set(weightedItem);
        }

        @Override
        public void add(E e) {
            WeightedItem weightedItem = new WeightedItem(e, 1);
            this.realIterator.add(weightedItem);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Itr
    implements Iterator<E> {
        Iterator<WeightedItem<E>> realIterator;

        private Itr() {
            this.realIterator = WeightedList.this.theData.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.realIterator.hasNext();
        }

        @Override
        public E next() {
            WeightedItem weightedItem = this.realIterator.next();
            return weightedItem.getElement();
        }

        @Override
        public void remove() {
            this.realIterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WeightedItem<T> {
        private T theElement;
        private int theWeight;

        public WeightedItem(T t, int n) {
            this.theElement = t;
            this.theWeight = n;
        }

        public final T getElement() {
            return this.theElement;
        }

        public final int getWeight() {
            return this.theWeight;
        }

        public void addWeight(int n) {
            this.theWeight += n;
        }

        public boolean equals(Object object) {
            return this.theElement.equals(object);
        }

        public int hashCode() {
            return this.theElement.hashCode();
        }

        public String toString() {
            return this.theElement.toString();
        }
    }
}

