/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util.enumeration;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import pcgen.core.spell.Spell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ProhibitedSpellType {
    ALIGNMENT("Alignment"){

        @Override
        public Collection<String> getCheckList(Spell spell) {
            return spell.getDescriptorList();
        }

        @Override
        public int getRequiredCount(List<String> list) {
            return list.size();
        }
    }
    ,
    DESCRIPTOR("Descriptor"){

        @Override
        public Collection<String> getCheckList(Spell spell) {
            return spell.getDescriptorList();
        }

        @Override
        public int getRequiredCount(List<String> list) {
            return list.size();
        }
    }
    ,
    SCHOOL("School"){

        @Override
        public Collection<String> getCheckList(Spell spell) {
            return spell.getSchools();
        }

        @Override
        public int getRequiredCount(List<String> list) {
            return list.size();
        }
    }
    ,
    SUBSCHOOL("SubSchool"){

        @Override
        public Collection<String> getCheckList(Spell spell) {
            return spell.getSubschools();
        }

        @Override
        public int getRequiredCount(List<String> list) {
            return list.size();
        }
    }
    ,
    SPELL("Spell"){

        @Override
        public Collection<String> getCheckList(Spell spell) {
            return Collections.singletonList(spell.getKeyName());
        }

        @Override
        public int getRequiredCount(List<String> list) {
            return 1;
        }
    };

    private final String text;

    private ProhibitedSpellType(String string2) {
        this.text = string2;
    }

    public abstract Collection<String> getCheckList(Spell var1);

    public abstract int getRequiredCount(List<String> var1);

    public String toString() {
        return this.text;
    }
}

