/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.parser;

import java.util.ArrayList;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.AbstractPrerequisiteListParser;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public class PreAbilityParser
extends AbstractPrerequisiteListParser
implements PrerequisiteParserInterface {
    private static final String CATEGORY = "CATEGORY.";
    private static final String CATEGORY_EQUALS = "CATEGORY=";

    public String[] kindsHandled() {
        return new String[]{"ability"};
    }

    public Prerequisite parse(String string, String string2, boolean bl, boolean bl2) throws PersistenceLayerException {
        Prerequisite prerequisite = super.parse(string, string2, bl, bl2);
        this.extractCategory(prerequisite);
        if (string2.indexOf(91) >= 0) {
            this.negateAbilityChoice(prerequisite);
        }
        this.convertKeysToSubKeys(prerequisite, "ability");
        prerequisite.setOverrideQualify(bl2);
        return prerequisite;
    }

    private void extractCategory(Prerequisite prerequisite) throws PersistenceLayerException {
        Object object5;
        Object object2;
        Object object3;
        Object object4 = "";
        boolean bl = false;
        if (prerequisite.getPrerequisites().size() == 0 && (((String)(object3 = prerequisite.getKey())).toUpperCase().startsWith(CATEGORY) || ((String)object3).toUpperCase().startsWith(CATEGORY_EQUALS))) {
            object2 = ((String)object3).substring(CATEGORY.length());
            if (((String)object2).toUpperCase().trim().equals("ANY")) {
                bl = true;
            } else {
                object4 = object2;
            }
            prerequisite.setKey("ANY");
            prerequisite.setCategoryName((String)object4);
        }
        object3 = new ArrayList(prerequisite.getPrerequisites());
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object5 = (Prerequisite)object2.next();
            if (object5.getKind() == null) {
                this.extractCategory((Prerequisite)object5);
                continue;
            }
            String string = object5.getKey();
            if (!string.toUpperCase().startsWith(CATEGORY) && !string.toUpperCase().startsWith(CATEGORY_EQUALS)) continue;
            String string2 = string.substring(CATEGORY.length());
            if (((String)object4).length() > 0) {
                throw new PersistenceLayerException(PropertyFactory.getFormattedString((String)"Errors.PreAbility.MultipleCategory", (Object[])new Object[]{object4, string2}));
            }
            if (object5 != object3.get(0)) {
                throw new PersistenceLayerException(PropertyFactory.getFormattedString((String)"Errors.PreAbility.CategoryNotFirst", (Object[])new Object[]{string2}));
            }
            if (string2.toUpperCase().trim().equals("ANY")) {
                bl = true;
            } else {
                object4 = string2;
            }
            prerequisite.getPrerequisites().remove(object5);
        }
        if (((String)object4).length() > 0) {
            for (Object object5 : prerequisite.getPrerequisites()) {
                object5.setCategoryName((String)object4);
            }
        } else if (!bl) {
            if (prerequisite.getPrerequisites().size() == 0) {
                object2 = prerequisite.getKey();
            } else {
                object5 = new StringBuilder();
                for (String string2 : prerequisite.getPrerequisites()) {
                    ((StringBuilder)object5).append(string2.getKey()).append(',');
                }
                ((StringBuilder)object5).setLength(((StringBuilder)object5).length() - 1);
                object2 = ((StringBuilder)object5).toString();
            }
            Logging.errorPrint((String)("PREABILITY: found without CATEGORY: " + (String)object2));
        }
    }

    private void negateAbilityChoice(Prerequisite prerequisite) {
        int n = 0;
        for (Prerequisite prerequisite2 : prerequisite.getPrerequisites()) {
            if (prerequisite2.getKind() == null) {
                this.negateAbilityChoice(prerequisite2);
                continue;
            }
            String string = prerequisite2.getKey();
            if (!string.startsWith("[") || !string.endsWith("]")) continue;
            string = string.substring(1, string.length() - 1);
            prerequisite2.setKey(string);
            prerequisite2.setOperator(prerequisite2.getOperator().invert());
            ++n;
        }
        if (n > 0) {
            Object object = prerequisite.getOperand();
            try {
                object = Integer.toString(Integer.parseInt((String)object) + n);
            }
            catch (NumberFormatException numberFormatException) {
                object = "(" + (String)object + ")+" + Integer.toString(n);
            }
            prerequisite.setOperand((String)object);
        }
    }
}

