/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.WeaponProf;
import pcgen.core.prereq.AbstractPrerequisiteTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.core.spell.Spell;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreAbilityTester
extends AbstractPrerequisiteTest
implements PrerequisiteTest {
    public int passes(Prerequisite prerequisite, Equipment equipment, PlayerCharacter playerCharacter) throws PrerequisiteException {
        if (playerCharacter == null) {
            return 0;
        }
        return this.passes(prerequisite, playerCharacter);
    }

    public int passes(Prerequisite prerequisite, PlayerCharacter playerCharacter) throws PrerequisiteException {
        boolean bl;
        int n;
        boolean bl2 = prerequisite.isCountMultiples();
        try {
            n = Integer.parseInt(prerequisite.getOperand());
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrerequisiteException(PropertyFactory.getFormattedString((String)"PreAbility.error", (Object[])new Object[]{prerequisite.toString()}));
        }
        GameMode gameMode = SettingsHandler.getGame();
        String string = prerequisite.getKey();
        String string2 = prerequisite.getSubKey();
        String string3 = prerequisite.getCategoryName();
        AbilityCategory abilityCategory = gameMode.getAbilityCategory(string3);
        boolean bl3 = string.equalsIgnoreCase("ANY");
        boolean bl4 = string.startsWith("TYPE=") || string.startsWith("TYPE.");
        boolean bl5 = bl = string2 != null && (string2.startsWith("TYPE=") || string2.startsWith("TYPE."));
        if (bl4) {
            string = string.substring(5);
        }
        if (bl) {
            string2 = string2.substring(5);
        }
        int n2 = 0;
        List<Ability> list = this.buildAbilityList(playerCharacter, string3, abilityCategory);
        if (!list.isEmpty()) {
            for (Ability ability : list) {
                String string4 = ability.getKeyName();
                if (bl3 || !bl4 && string4.equalsIgnoreCase(string) || bl4 && ability.isType(string)) {
                    if (string2 != null) {
                        n2 += this.checkForSubKeyMatch(playerCharacter, bl2, string, string2, bl, ability);
                        continue;
                    }
                    ++n2;
                    if (!ability.isMultiples() || !bl2) continue;
                    n2 += ability.getAssociatedCount() - 1;
                    continue;
                }
                if (string2 == null) continue;
                String string5 = string + " (" + string2 + ")";
                String string6 = string + "(" + string2 + ")";
                if (!string4.equalsIgnoreCase(string5) && !ability.getKeyName().equalsIgnoreCase(string6)) continue;
                ++n2;
                if (bl2) continue;
                break;
            }
        }
        n2 = prerequisite.getOperator().compare(n2, n);
        return this.countedTotal(prerequisite, n2);
    }

    private int checkForSubKeyMatch(PlayerCharacter playerCharacter, boolean bl, String string, String string2, boolean bl2, Ability ability) {
        int n;
        block7: {
            block5: {
                String string3;
                ArrayList arrayList;
                String string4;
                block9: {
                    block8: {
                        block6: {
                            string4 = string2;
                            ArrayList arrayList2 = new ArrayList();
                            arrayList = new ArrayList();
                            string3 = ability.getChoiceString();
                            n = 0;
                            ability.modChoices(arrayList2, arrayList, false, playerCharacter, true, null);
                            arrayList2.clear();
                            if (!bl2) break block5;
                            if (!string3.startsWith("SKILL")) break block6;
                            n = this.subKeySkill(bl, n, string4, arrayList);
                            break block7;
                        }
                        if (!string3.startsWith("WEAPONPROFS")) break block8;
                        n = this.subKeyWeaponProf(bl, n, string4, arrayList);
                        break block7;
                    }
                    if (!string3.startsWith("DOMAIN")) break block9;
                    n = this.subKeyDomain(bl, n, string4, arrayList);
                    break block7;
                }
                if (!string3.startsWith("SPELL")) break block7;
                n = this.subKeySpell(bl, n, string4, arrayList);
                break block7;
            }
            if (ability.getKeyName().equalsIgnoreCase(string) && ability.containsAssociated(string2)) {
                ++n;
                if (ability.isMultiples() && bl) {
                    n += ability.getAssociatedCount() - 1;
                }
            } else {
                int n2 = string2.indexOf(37);
                if (n2 > -1) {
                    for (int i = 0; i < ability.getAssociatedCount(); ++i) {
                        String string5 = ability.getAssociated(i).toUpperCase();
                        if (n2 != 0 && !string5.startsWith(string2.substring(0, n2 - 1).toUpperCase())) continue;
                        ++n;
                        if (!bl) break;
                    }
                }
            }
        }
        return n;
    }

    private List<Ability> buildAbilityList(PlayerCharacter playerCharacter, String string, AbilityCategory abilityCategory) {
        ArrayList<Ability> arrayList = new ArrayList<Ability>();
        if (playerCharacter != null) {
            if (string == null) {
                Collection collection = SettingsHandler.getGame().getAllAbilityCategories();
                for (AbilityCategory abilityCategory2 : collection) {
                    arrayList.addAll(playerCharacter.getAggregateAbilityList(abilityCategory2));
                }
            } else {
                arrayList.addAll(playerCharacter.getAggregateAbilityList(abilityCategory));
            }
        }
        return arrayList;
    }

    private int subKeySpell(boolean bl, int n, String string, List list) {
        int n2 = n;
        for (Object e : list) {
            String string2 = null;
            string2 = e instanceof PObject ? ((PObject)e).getKeyName() : e.toString();
            Spell spell = Globals.getSpellKeyed((String)string2);
            if (spell == null || !spell.isType(string)) continue;
            ++n2;
            if (bl) continue;
            break;
        }
        return n2;
    }

    private int subKeyDomain(boolean bl, int n, String string, List list) {
        int n2 = n;
        for (Object e : list) {
            Domain domain = Globals.getDomainKeyed((String)e.toString());
            if (domain == null || !domain.isType(string)) continue;
            ++n2;
            if (bl) continue;
            break;
        }
        return n2;
    }

    private int subKeyWeaponProf(boolean bl, int n, String string, List list) {
        int n2 = n;
        for (Object e : list) {
            Equipment equipment;
            WeaponProf weaponProf = Globals.getWeaponProfKeyed((String)e.toString());
            if (weaponProf == null || (equipment = EquipmentList.getEquipmentKeyed((String)weaponProf.getKeyName())) == null || !equipment.isType(string)) continue;
            ++n2;
            if (bl) continue;
            break;
        }
        return n2;
    }

    private int subKeySkill(boolean bl, int n, String string, List list) {
        int n2 = n;
        for (Object e : list) {
            Skill skill = Globals.getSkillKeyed((String)e.toString());
            if (skill == null || !skill.isType(string)) continue;
            ++n2;
            if (bl) continue;
            break;
        }
        return n2;
    }

    public String toHtmlString(Prerequisite prerequisite) {
        String string = prerequisite.getKey();
        if (prerequisite.getSubKey() != null && !prerequisite.getSubKey().equals("")) {
            string = string + " ( " + prerequisite.getSubKey() + " )";
        }
        if (string.startsWith("TYPE=")) {
            if (prerequisite.getCategoryName().length() > 0) {
                return PropertyFactory.getFormattedString((String)"PreAbility.type.toHtml", (Object[])new Object[]{prerequisite.getOperator().toDisplayString(), prerequisite.getOperand(), prerequisite.getCategoryName(), string.substring(5)});
            }
            return PropertyFactory.getFormattedString((String)"PreAbility.type.noCat.toHtml", (Object[])new Object[]{prerequisite.getOperator().toDisplayString(), prerequisite.getOperand(), string.substring(5)});
        }
        return PropertyFactory.getFormattedString((String)"PreAbility.toHtml", (Object[])new Object[]{prerequisite.getCategoryName(), string, prerequisite.getOperator().toDisplayString(), prerequisite.getOperand()});
    }

    public String kindHandled() {
        return "ABILITY";
    }
}

