/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.logging.Level;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UmultLst
implements CDOMPrimaryToken<CDOMObject> {
    public String getTokenName() {
        return "UMULT";
    }

    public boolean parse(LoadContext loadContext, CDOMObject cDOMObject, String string) {
        if (".CLEAR".equals(string)) {
            loadContext.getObjectContext().put(cDOMObject, IntegerKey.UMULT, null);
        } else {
            try {
                Integer n = Integer.valueOf(string);
                if (n <= 0) {
                    Logging.log((Level)Logging.LST_ERROR, (String)("Invalid " + this.getTokenName() + ": " + string));
                    Logging.log((Level)Logging.LST_ERROR, (String)"  Expecting a positive integer");
                    return false;
                }
                loadContext.getObjectContext().put(cDOMObject, IntegerKey.UMULT, n);
            }
            catch (NumberFormatException numberFormatException) {
                Logging.log((Level)Logging.LST_ERROR, (String)("Invalid " + this.getTokenName() + ": " + string));
                Logging.log((Level)Logging.LST_ERROR, (String)"  Expecting an integer");
                return false;
            }
        }
        return true;
    }

    public String[] unparse(LoadContext loadContext, CDOMObject cDOMObject) {
        Integer n = loadContext.getObjectContext().getInteger(cDOMObject, IntegerKey.UMULT);
        if (n == null) {
            return null;
        }
        if (n <= 0) {
            loadContext.addWriteMessage(this.getTokenName() + " must be an integer > 0");
            return null;
        }
        return new String[]{n.toString()};
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }
}

