/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit.gear;

import pcgen.core.kit.KitGear;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxCostToken
extends AbstractToken
implements CDOMSecondaryToken<KitGear> {
    public String getTokenName() {
        return "MAXCOST";
    }

    public Class<KitGear> getTokenClass() {
        return KitGear.class;
    }

    public String getParentToken() {
        return "*KITTOKEN";
    }

    public boolean parse(LoadContext loadContext, KitGear kitGear, String string) {
        try {
            Integer n = Integer.valueOf(string);
            if (n <= 0) {
                Logging.errorPrint((String)(this.getTokenName() + " expected an integer > 0"));
                return false;
            }
            kitGear.setMaxCost(n);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint((String)(this.getTokenName() + " expected an integer.  Tag must be of the form: " + this.getTokenName() + ":<int>"));
            return false;
        }
    }

    public String[] unparse(LoadContext loadContext, KitGear kitGear) {
        Integer n = kitGear.getMaxCost();
        if (n == null) {
            return null;
        }
        return new String[]{n.toString()};
    }
}

