/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.auto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ChooseResultActor;
import pcgen.cdom.content.ConditionalChoiceActor;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.helper.WeaponProfProvider;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.QualifiedObject;
import pcgen.core.WeaponProf;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeaponProfToken
extends AbstractToken
implements CDOMSecondaryToken<CDOMObject>,
ChooseResultActor {
    private static final Class<WeaponProf> WEAPONPROF_CLASS = WeaponProf.class;

    public String getParentToken() {
        return "AUTO";
    }

    public String getTokenName() {
        return "WEAPONPROF";
    }

    private String getFullName() {
        return this.getParentToken() + ":" + this.getTokenName();
    }

    public boolean parse(LoadContext loadContext, CDOMObject cDOMObject, String string) {
        int n;
        String string2;
        if (this.isEmpty(string)) {
            return false;
        }
        Prerequisite prerequisite = null;
        if (string.indexOf("[") == -1) {
            string2 = string;
        } else {
            n = string.indexOf("[");
            string2 = string.substring(0, n);
            if (!string.endsWith("]")) {
                Logging.log((Level)Logging.LST_ERROR, (String)("Unresolved Prerequisite in " + this.getFullName() + " " + string + " in " + this.getFullName()));
                return false;
            }
            prerequisite = this.getPrerequisite(string.substring(n + 1, string.length() - 1));
            if (prerequisite == null) {
                Logging.log((Level)Logging.LST_ERROR, (String)("Error generating Prerequisite " + prerequisite + " in " + this.getFullName()));
                return false;
            }
        }
        if (this.hasIllegalSeparator('|', string2)) {
            return false;
        }
        n = 0;
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        WeaponProfProvider weaponProfProvider = new WeaponProfProvider();
        while (stringTokenizer.hasMoreTokens()) {
            WeaponProfToken weaponProfToken;
            String string3 = stringTokenizer.nextToken();
            if ("%LIST".equals(string3)) {
                if (prerequisite == null) {
                    weaponProfToken = this;
                } else {
                    ConditionalChoiceActor conditionalChoiceActor = new ConditionalChoiceActor((ChooseResultActor)this);
                    conditionalChoiceActor.addPrerequisite(prerequisite);
                    weaponProfToken = conditionalChoiceActor;
                }
                loadContext.obj.addToList(cDOMObject, ListKey.CHOOSE_ACTOR, (Object)weaponProfToken);
                continue;
            }
            if ("DEITYWEAPONS".equals(string3)) {
                loadContext.obj.put(cDOMObject, ObjectKey.HAS_DEITY_WEAPONPROF, (Object)new QualifiedObject((Object)Boolean.TRUE, prerequisite));
                continue;
            }
            if ("ALL".equalsIgnoreCase(string3)) {
                n = 1;
                loadContext.obj.put(cDOMObject, ObjectKey.HAS_ALL_WEAPONPROF, (Object)new QualifiedObject((Object)Boolean.TRUE, prerequisite));
                continue;
            }
            bl = true;
            if (string3.startsWith("TYPE.") || string3.startsWith("TYPE=")) {
                weaponProfToken = TokenUtilities.getTypeReference((LoadContext)loadContext, WEAPONPROF_CLASS, (String)string3.substring(5));
                if (weaponProfToken == null) {
                    return false;
                }
                weaponProfProvider.addWeaponProfType((CDOMGroupRef)weaponProfToken);
                continue;
            }
            weaponProfToken = loadContext.ref.getCDOMReference(WEAPONPROF_CLASS, string3);
            weaponProfProvider.addWeaponProf((CDOMSingleRef)weaponProfToken);
        }
        if (n != 0 && bl) {
            Logging.log((Level)Logging.LST_ERROR, (String)("Non-sensical " + this.getFullName() + ": Contains ANY and a specific reference: " + string));
            return false;
        }
        if (!weaponProfProvider.isEmpty()) {
            if (prerequisite != null) {
                weaponProfProvider.addPrerequisite(prerequisite);
            }
            loadContext.obj.addToList(cDOMObject, ListKey.WEAPONPROF, (Object)weaponProfProvider);
        }
        return true;
    }

    public String[] unparse(LoadContext loadContext, CDOMObject cDOMObject) {
        Iterator iterator;
        ArrayList<String> arrayList = new ArrayList<String>();
        Changes changes = loadContext.getObjectContext().getListChanges(cDOMObject, ListKey.CHOOSE_ACTOR);
        Changes changes2 = loadContext.obj.getListChanges(cDOMObject, ListKey.WEAPONPROF);
        QualifiedObject qualifiedObject = (QualifiedObject)loadContext.obj.getObject(cDOMObject, ObjectKey.HAS_DEITY_WEAPONPROF);
        QualifiedObject qualifiedObject2 = (QualifiedObject)loadContext.obj.getObject(cDOMObject, ObjectKey.HAS_ALL_WEAPONPROF);
        Collection collection = changes2.getAdded();
        Collection collection2 = changes.getAdded();
        if (collection2 != null && !collection2.isEmpty()) {
            for (ChooseResultActor chooseResultActor : collection2) {
                if (!chooseResultActor.getSource().equals(this.getTokenName())) continue;
                try {
                    arrayList.add(chooseResultActor.getLstFormat());
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    loadContext.addWriteMessage("Error writing Prerequisite: " + (Object)((Object)persistenceLayerException));
                    return null;
                }
            }
        }
        if (qualifiedObject != null) {
            iterator = new StringBuilder();
            ((StringBuilder)((Object)iterator)).append("DEITYWEAPONS");
            if (qualifiedObject.hasPrerequisites()) {
                ((StringBuilder)((Object)iterator)).append('[').append(loadContext.getPrerequisiteString((Collection)qualifiedObject.getPrerequisiteList())).append(']');
            }
            arrayList.add(((StringBuilder)((Object)iterator)).toString());
        }
        if (qualifiedObject2 != null) {
            iterator = new StringBuilder();
            ((StringBuilder)((Object)iterator)).append("ALL");
            if (qualifiedObject2.hasPrerequisites()) {
                ((StringBuilder)((Object)iterator)).append('[').append(loadContext.getPrerequisiteString((Collection)qualifiedObject2.getPrerequisiteList())).append(']');
            }
            arrayList.add(((StringBuilder)((Object)iterator)).toString());
        }
        if (collection != null) {
            for (ChooseResultActor chooseResultActor : collection) {
                String string = chooseResultActor.getLstFormat();
                List list = chooseResultActor.getPrerequisiteList();
                if (list != null && !list.isEmpty()) {
                    if (list.size() > 1) {
                        loadContext.addWriteMessage("Error: " + cDOMObject.getClass().getSimpleName() + " had more than one Prerequisite for " + this.getFullName());
                        return null;
                    }
                    string = string + '[' + loadContext.getPrerequisiteString((Collection)list) + ']';
                }
                arrayList.add(string);
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    public void apply(PlayerCharacter playerCharacter, CDOMObject cDOMObject, String string) {
        WeaponProf weaponProf = (WeaponProf)Globals.getContext().ref.silentlyGetConstructedCDOMObject(WEAPONPROF_CLASS, string);
        if (weaponProf != null) {
            playerCharacter.addAssoc((Object)cDOMObject, AssociationListKey.WEAPONPROF, (Object)weaponProf);
        }
    }

    public void remove(PlayerCharacter playerCharacter, CDOMObject cDOMObject, String string) {
        WeaponProf weaponProf = (WeaponProf)Globals.getContext().ref.silentlyGetConstructedCDOMObject(WEAPONPROF_CLASS, string);
        if (weaponProf != null) {
            playerCharacter.removeAssoc((Object)cDOMObject, AssociationListKey.WEAPONPROF, (Object)weaponProf);
        }
    }

    public String getSource() {
        return this.getTokenName();
    }

    public String getLstFormat() {
        return "%LIST";
    }
}

