/*
 * Decompiled with CFR 0.152.
 */
package plugin.initiative;

import gmgen.GMGenSystem;
import gmgen.GMGenSystemView;
import gmgen.gui.PreferencesPanel;
import gmgen.io.SimpleFileFilter;
import gmgen.plugin.InitHolder;
import gmgen.plugin.InitHolderList;
import gmgen.plugin.PcgCombatant;
import gmgen.pluginmgr.GMBComponent;
import gmgen.pluginmgr.GMBMessage;
import gmgen.pluginmgr.GMBPlugin;
import gmgen.pluginmgr.GMBus;
import gmgen.pluginmgr.messages.CombatRequestMessage;
import gmgen.pluginmgr.messages.FileOpenMessage;
import gmgen.pluginmgr.messages.FileTypeMessage;
import gmgen.pluginmgr.messages.InitHolderListSendMessage;
import gmgen.pluginmgr.messages.OpenMessage;
import gmgen.pluginmgr.messages.OpenPCGRequestMessage;
import gmgen.pluginmgr.messages.PCClosedMessage;
import gmgen.pluginmgr.messages.PCLoadedMessage;
import gmgen.pluginmgr.messages.PreferencesPanelAddMessage;
import gmgen.pluginmgr.messages.SaveMessage;
import gmgen.pluginmgr.messages.SavePCGRequestMessage;
import gmgen.pluginmgr.messages.StateChangedMessage;
import gmgen.pluginmgr.messages.TabAddMessage;
import gmgen.pluginmgr.messages.ToolMenuItemAddMessage;
import gmgen.pluginmgr.messages.WindowClosedMessage;
import gmgen.util.LogUtilities;
import gmgen.util.MiscUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.gui.ImagePreview;
import pcgen.gui.utils.TabbedPaneUtilities;
import pcgen.io.PCGFile;
import plugin.initiative.gui.Initiative;
import plugin.initiative.gui.PreferencesDamagePanel;
import plugin.initiative.gui.PreferencesInitiativePanel;
import plugin.initiative.gui.PreferencesMassiveDamagePanel;
import plugin.initiative.gui.PreferencesPerformancePanel;

public class InitiativePlugin
extends GMBPlugin {
    public static final String LOG_NAME = "Initiative";
    private Initiative theView;
    private JMenuItem initToolsItem = new JMenuItem();
    private String name = "Initiative";
    private String version = "01.00.99.01.00";

    public FileFilter[] getFileTypes() {
        FileFilter[] fileFilterArray = new FileFilter[]{this.getFileType()};
        return fileFilterArray;
    }

    public FileFilter getFileType() {
        String[] stringArray = new String[]{"gmi", "init"};
        return new SimpleFileFilter(stringArray, "Initiative Export");
    }

    public void start() {
        this.theView = new Initiative();
        GMBus.send((GMBMessage)new PreferencesPanelAddMessage((GMBComponent)this, this.name, (PreferencesPanel)new PreferencesDamagePanel()));
        GMBus.send((GMBMessage)new PreferencesPanelAddMessage((GMBComponent)this, this.name, (PreferencesPanel)new PreferencesMassiveDamagePanel()));
        GMBus.send((GMBMessage)new PreferencesPanelAddMessage((GMBComponent)this, this.name, (PreferencesPanel)new PreferencesInitiativePanel()));
        GMBus.send((GMBMessage)new PreferencesPanelAddMessage((GMBComponent)this, this.name, (PreferencesPanel)new PreferencesPerformancePanel()));
        this.theView.setLog(LogUtilities.inst());
        GMBus.send((GMBMessage)new TabAddMessage((GMBComponent)this, this.name, this.getView(), this.getPluginSystem()));
        this.initMenus();
    }

    public String getPluginSystem() {
        return SettingsHandler.getGMGenOption((String)"Initiative.System", (String)"GMGen");
    }

    public int getPluginLoadOrder() {
        return SettingsHandler.getGMGenOption((String)"Initiative.LoadOrder", (int)40);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public Component getView() {
        return this.theView;
    }

    public void fileOpen() {
        JFileChooser jFileChooser = ImagePreview.decorateWithImagePreview((JFileChooser)new JFileChooser());
        File file = SettingsHandler.getPcgPath();
        if (file.exists()) {
            jFileChooser.setCurrentDirectory(file);
        }
        String[] stringArray = new String[]{"pcg", "pcp"};
        String[] stringArray2 = new String[]{"gmi", "init"};
        SimpleFileFilter simpleFileFilter = new SimpleFileFilter(stringArray2, "Initiative Export");
        jFileChooser.addChoosableFileFilter((FileFilter)simpleFileFilter);
        jFileChooser.addChoosableFileFilter((FileFilter)new SimpleFileFilter(stringArray, "PCGen File"));
        jFileChooser.removeChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
        jFileChooser.setFileFilter((FileFilter)simpleFileFilter);
        jFileChooser.setMultiSelectionEnabled(true);
        Cursor cursor = MiscUtilities.setBusyCursor((Component)this.theView);
        int n = jFileChooser.showOpenDialog(this.theView);
        if (n == 0) {
            File[] fileArray = jFileChooser.getSelectedFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (PCGFile.isPCGenCharacterOrPartyFile((File)fileArray[i])) {
                    GMBus.send((GMBMessage)new OpenPCGRequestMessage((GMBComponent)this, fileArray[i], false));
                    continue;
                }
                if (!fileArray[i].toString().endsWith(".init") && !fileArray[i].toString().endsWith(".gmi")) continue;
                this.loadINIT(fileArray[i]);
            }
            this.theView.refreshTable();
        }
        MiscUtilities.setCursor((Component)this.theView, (Cursor)cursor);
    }

    public void handleCombatRequestMessage(CombatRequestMessage combatRequestMessage) {
        combatRequestMessage.setCombat(this.theView.initList);
    }

    public void handleFileOpenMessage(FileOpenMessage fileOpenMessage) {
        if (GMGenSystemView.getTabPane().getSelectedComponent() instanceof Initiative) {
            this.fileOpen();
        }
    }

    public void handleInitHolderListSendMessage(InitHolderListSendMessage initHolderListSendMessage) {
        if (initHolderListSendMessage.getSource() != this) {
            InitHolderList initHolderList = initHolderListSendMessage.getInitHolderList();
            for (int i = 0; i < initHolderList.size(); ++i) {
                InitHolder initHolder = (InitHolder)initHolderList.get(i);
                this.theView.addInitHolder(initHolder);
            }
            this.theView.refreshTable();
        }
    }

    public void handleMessage(GMBMessage gMBMessage) {
        if (gMBMessage instanceof FileOpenMessage) {
            this.handleFileOpenMessage((FileOpenMessage)gMBMessage);
        } else if (gMBMessage instanceof SaveMessage) {
            this.handleSaveMessage((SaveMessage)gMBMessage);
        } else if (gMBMessage instanceof InitHolderListSendMessage) {
            this.handleInitHolderListSendMessage((InitHolderListSendMessage)gMBMessage);
        } else if (gMBMessage instanceof PCLoadedMessage) {
            this.handlePCLoadedMessage((PCLoadedMessage)gMBMessage);
        } else if (gMBMessage instanceof PCClosedMessage) {
            this.handlePCClosedMessage((PCClosedMessage)gMBMessage);
        } else if (gMBMessage instanceof WindowClosedMessage) {
            this.handleWindowClosedMessage((WindowClosedMessage)gMBMessage);
        } else if (gMBMessage instanceof StateChangedMessage) {
            this.handleStateChangedMessage((StateChangedMessage)gMBMessage);
        } else if (gMBMessage instanceof CombatRequestMessage) {
            this.handleCombatRequestMessage((CombatRequestMessage)gMBMessage);
        } else if (gMBMessage instanceof OpenMessage) {
            this.handleOpenMessage((OpenMessage)gMBMessage);
        } else if (gMBMessage instanceof FileTypeMessage) {
            this.handleFileTypeMessage((FileTypeMessage)gMBMessage);
        }
    }

    private void handleFileTypeMessage(FileTypeMessage fileTypeMessage) {
        fileTypeMessage.addFileTypes(this.getFileTypes());
    }

    private void handleOpenMessage(OpenMessage openMessage) {
        File[] fileArray = openMessage.getFile();
        FileFilter fileFilter = this.getFileType();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileFilter.accept(fileArray[i])) continue;
            this.loadINIT(fileArray[i]);
        }
    }

    public void handlePCClosedMessage(PCClosedMessage pCClosedMessage) {
        this.theView.removePcgCombatant(pCClosedMessage.getPC());
        this.theView.refreshTable();
    }

    public void handlePCLoadedMessage(PCLoadedMessage pCLoadedMessage) {
        if (!pCLoadedMessage.isIgnored((GMBComponent)this)) {
            PlayerCharacter playerCharacter = pCLoadedMessage.getPC();
            String string = "PC";
            String string2 = playerCharacter.getPlayersName();
            if (string2.equalsIgnoreCase("Ally")) {
                string = "Ally";
            } else if (string2.equalsIgnoreCase("GM") || string2.equalsIgnoreCase("DM") || string2.equalsIgnoreCase("Enemy")) {
                string = "Enemy";
            } else if (string2.equals("-")) {
                string = "-";
            }
            this.theView.addPcgCombatant(playerCharacter, string);
            this.theView.refreshTable();
        }
    }

    public void fileSave() {
        for (int i = 0; i < this.theView.initList.size(); ++i) {
            InitHolder initHolder = (InitHolder)this.theView.initList.get(i);
            if (!(initHolder instanceof PcgCombatant)) continue;
            PcgCombatant pcgCombatant = (PcgCombatant)initHolder;
            GMBus.send((GMBMessage)new SavePCGRequestMessage((GMBComponent)this, pcgCombatant.getPC()));
        }
        this.theView.saveToFile();
    }

    public void handleSaveMessage(SaveMessage saveMessage) {
        if (this.isActive()) {
            this.fileSave();
            saveMessage.veto();
        }
    }

    public void handleStateChangedMessage(StateChangedMessage stateChangedMessage) {
        if (this.isActive()) {
            this.initToolsItem.setEnabled(false);
            if (GMGenSystem.inst != null) {
                GMGenSystem.inst.openFileItem.setEnabled(true);
                GMGenSystem.inst.saveFileItem.setEnabled(true);
            }
            this.theView.refreshTable();
            if (SettingsHandler.getGMGenOption((String)"Initiative.refreshOnStateChange", (boolean)true)) {
                this.theView.refreshTabs();
            }
        } else {
            this.initToolsItem.setEnabled(true);
        }
    }

    public void handleWindowClosedMessage(WindowClosedMessage windowClosedMessage) {
        this.theView.setExitPrefs();
    }

    public boolean isActive() {
        JTabbedPane jTabbedPane = TabbedPaneUtilities.getTabbedPaneFor((Component)this.theView);
        return jTabbedPane != null && JOptionPane.getFrameForComponent(jTabbedPane).isFocused() && jTabbedPane.getSelectedComponent().equals(this.theView);
    }

    public void initMenuItem(ActionEvent actionEvent) {
        JTabbedPane jTabbedPane = GMGenSystemView.getTabPane();
        for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
            if (!(jTabbedPane.getComponentAt(i) instanceof Initiative)) continue;
            jTabbedPane.setSelectedIndex(i);
        }
    }

    public void initMenus() {
        this.initToolsItem.setMnemonic('I');
        this.initToolsItem.setText(LOG_NAME);
        this.initToolsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InitiativePlugin.this.initMenuItem(actionEvent);
            }
        });
        GMBus.send((GMBMessage)new ToolMenuItemAddMessage((GMBComponent)this, this.initToolsItem));
    }

    public void loadINIT(File file) {
        this.theView.loadINIT(file, (GMBComponent)this);
    }
}

