/*
 * Decompiled with CFR 0.152.
 */
package plugin.initiative.gui;

import gmgen.plugin.InitHolder;
import gmgen.plugin.Spell;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pcgen.gui.utils.JLabelPane;
import plugin.initiative.SpellModel;
import plugin.initiative.gui.Initiative;
import plugin.initiative.gui.StartEvent;

public class CastSpell
extends StartEvent {
    protected JLabelPane descText;
    protected JPanel descPanel;
    protected JScrollPane descScroll;

    public CastSpell(Frame frame, boolean bl, Initiative initiative) {
        super(frame, bl, initiative);
    }

    public CastSpell(Frame frame, boolean bl, Initiative initiative, String string, int n) {
        super(frame, bl, initiative, string, n);
    }

    public void setSpellModel(SpellModel spellModel) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.descPanel.getComponents().length == 0) {
            this.descText = new JLabelPane();
            this.descScroll = new JScrollPane((Component)this.descText);
            this.descPanel.add((Component)this.descScroll, "Center");
        }
        this.descText.setBackground(this.getContentPane().getBackground());
        stringBuffer.append("<html><body><font size='-2'>");
        stringBuffer.append("<b>Duration: </b>" + spellModel.getDuration() + " ");
        stringBuffer.append("<b>Range: </b>" + spellModel.getRange() + " ");
        stringBuffer.append("<b>Save: </b>" + spellModel.getSaveInfo() + " ");
        stringBuffer.append("<b>Cast: </b>" + spellModel.getCastingTime() + " ");
        stringBuffer.append("<b>Target/Area: </b>" + spellModel.getTarget() + " ");
        stringBuffer.append("<b>Desc: </b>" + spellModel.getDesc() + " ");
        stringBuffer.append("</font></body></html>");
        this.descText.setText(stringBuffer.toString());
        this.descPanel.setPreferredSize(new Dimension(this.mainPanel.getWidth() - 16, 75));
        this.descPanel.setMaximumSize(new Dimension(this.mainPanel.getWidth() - 16, 75));
        this.descPanel.setMinimumSize(new Dimension(this.mainPanel.getWidth() - 16, 75));
        this.pack();
        this.tEffect.setText(spellModel.getDesc());
    }

    public void setSpellName(String string) {
        this.tName.setText(string);
    }

    protected void save() {
        this.initiative.initList.add((InitHolder)new Spell(this.tName.getText(), this.tPlayer.getText(), this.tEffect.getText(), ((Integer)this.lDuration.getValue()).intValue(), ((Integer)this.lInit.getValue()).intValue(), this.cbAlert.isSelected()));
        this.initiative.writeToCombatTabWithRound(this.tPlayer.getText() + " Cast " + this.tName.getText());
        this.initiative.refreshTable();
        this.initiative.grabFocus();
        this.initiative.focusNextInit();
        this.setVisible(false);
        this.dispose();
    }

    protected void initComponents() {
        this.sTitle = "Cast Spell";
        this.sAlertLabel = "Alert when spell duration expires";
        this.basicSetup();
        this.initAllDefaultComponents();
        this.addDescriptionPanel();
        this.addButtons();
        this.finalizeSetup();
    }

    private void addDescriptionPanel() {
        GridBagConstraints gridBagConstraints = null;
        this.descPanel = new JPanel(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.gridBagRow++;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.descPanel, gridBagConstraints);
    }
}

