/*
 * Decompiled with CFR 0.152.
 */
package plugin.initiative.gui;

import gmgen.plugin.Combatant;
import gmgen.plugin.Dice;
import gmgen.plugin.PcgCombatant;
import gmgen.plugin.PlayerCharacterOutput;
import gmgen.plugin.SystemAttribute;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import plugin.initiative.SaveModel;
import plugin.initiative.XMLCombatant;
import plugin.initiative.gui.Utils;

public class SavingThrowDialog
extends JDialog {
    public static final int NULL_SAVE = 0;
    public static final int FORT_SAVE = 1;
    public static final int REF_SAVE = 2;
    public static final int WILL_SAVE = 3;
    public static final int CANCEL_OPTION = 0;
    public static final int PASS_OPTION = 1;
    public static final int FAIL_OPTION = 2;
    private ButtonGroup saveTypeGroup;
    private Combatant cbt;
    private JButton cancelButton;
    private JButton failButton;
    private JButton passButton;
    private JButton rollButton;
    private JLabel characterName;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JRadioButton fortitudeSelection;
    private JRadioButton reflexSelection;
    private JRadioButton willSelection;
    private JSeparator jSeparator1;
    private JSlider saveDCSlider;
    private JSlider saveMagicSlider;
    private JSlider saveTempSlider;
    private JTextField saveAbility;
    private JTextField saveBase;
    private JFormattedTextField saveDC;
    private JFormattedTextField saveMagic;
    private JTextField saveMisc;
    private JFormattedTextField saveTemp;
    private JTextField saveTotal;
    private int lastRoll = 0;
    private int retValue = 0;
    private SaveModel m_saveModel;

    public SavingThrowDialog(Frame frame, boolean bl, Combatant combatant) {
        this(frame, bl, combatant, 0, 0);
    }

    public SavingThrowDialog(Frame frame, boolean bl, Combatant combatant, int n, int n2) {
        super(frame, bl);
        this.initComponents();
        this.cbt = combatant;
        this.setLocation(frame.getX() + 100, frame.getY() + 100);
        this.setCharacterName(combatant);
        this.setSaveType(n, n2);
        this.setDefaults(n2);
    }

    public SavingThrowDialog(Frame frame, boolean bl, Combatant combatant, SaveModel saveModel) {
        super(frame, bl);
        this.initComponents();
        this.cbt = combatant;
        this.setLocation(frame.getX() + 100, frame.getY() + 100);
        this.setCharacterName(combatant);
        int n = "FORTITUDE".equals(saveModel.getSaveType()) ? 1 : ("REFLEX".equals(saveModel.getSaveType()) ? 2 : ("WILL".equals(saveModel.getSaveType()) ? 3 : 0));
        this.setSaveModel(saveModel);
        this.setSaveType(saveModel.getDc(), n);
        this.setDefaults(n);
    }

    private void setSaveModel(SaveModel saveModel) {
        this.m_saveModel = saveModel;
    }

    public int getDC() {
        return this.getFieldValue(this.saveDC);
    }

    public int getReturnValue() {
        return this.retValue;
    }

    public int getRoll() {
        return this.lastRoll;
    }

    public String getSaveAbbrev(int n) {
        if (n == 1) {
            return "Fort";
        }
        if (n == 2) {
            return "Ref";
        }
        if (n == 3) {
            return "Will";
        }
        return "";
    }

    public int getSaveType() {
        if (this.fortitudeSelection.isSelected()) {
            return 1;
        }
        if (this.reflexSelection.isSelected()) {
            return 2;
        }
        if (this.willSelection.isSelected()) {
            return 3;
        }
        return 0;
    }

    public int getTotal() {
        return this.getFieldValue(this.saveTotal);
    }

    private void setCharacterName(Combatant combatant) {
        this.setCharacterName(combatant.getName());
    }

    private void setCharacterName(String string) {
        this.characterName.setText(string);
    }

    private void setDefaults(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.cbt instanceof PcgCombatant) {
            PcgCombatant pcgCombatant = (PcgCombatant)this.cbt;
            PlayerCharacter playerCharacter = pcgCombatant.getPC();
            new PlayerCharacterOutput(playerCharacter);
            List list = SettingsHandler.getGame().getUnmodifiableCheckList();
            if (n == 1) {
                n2 = playerCharacter.calculateSaveBonus(1, ((PObject)list.get(0)).toString(), "BASE");
                n3 = playerCharacter.calculateSaveBonus(1, ((PObject)list.get(0)).toString(), "STATMOD");
                n4 = playerCharacter.calculateSaveBonus(1, ((PObject)list.get(0)).toString(), "MAGIC");
                n5 = playerCharacter.calculateSaveBonus(1, ((PObject)list.get(0)).toString(), "MISC.NOMAGIC.NOSTAT");
            } else if (n == 2) {
                n2 = playerCharacter.calculateSaveBonus(2, ((PObject)list.get(1)).toString(), "BASE");
                n3 = playerCharacter.calculateSaveBonus(2, ((PObject)list.get(1)).toString(), "STATMOD");
                n4 = playerCharacter.calculateSaveBonus(2, ((PObject)list.get(1)).toString(), "MAGIC");
                n5 = playerCharacter.calculateSaveBonus(2, ((PObject)list.get(1)).toString(), "MISC.NOMAGIC.NOSTAT");
            } else if (n == 3) {
                n2 = playerCharacter.calculateSaveBonus(3, ((PObject)list.get(2)).toString(), "BASE");
                n3 = playerCharacter.calculateSaveBonus(3, ((PObject)list.get(2)).toString(), "STATMOD");
                n4 = playerCharacter.calculateSaveBonus(3, ((PObject)list.get(2)).toString(), "MAGIC");
                n5 = playerCharacter.calculateSaveBonus(3, ((PObject)list.get(2)).toString(), "MISC.NOMAGIC.NOSTAT");
            }
        } else if (this.cbt instanceof XMLCombatant) {
            XMLCombatant xMLCombatant = (XMLCombatant)this.cbt;
            if (n == 1) {
                int n6;
                n3 = n6 = new SystemAttribute("Constitution", xMLCombatant.getAttribute("Constitution")).getModifier();
                n2 = xMLCombatant.getSave("Fortitude") - n6;
            } else if (n == 2) {
                int n7;
                n3 = n7 = new SystemAttribute("Dexterity", xMLCombatant.getAttribute("Dexterity")).getModifier();
                n2 = xMLCombatant.getSave("Reflex") - n7;
            } else if (n == 3) {
                int n8;
                n3 = n8 = new SystemAttribute("Wisdom", xMLCombatant.getAttribute("Wisdom")).getModifier();
                n2 = xMLCombatant.getSave("Will") - n8;
            }
            n4 = this.parseInt(this.saveMagic.getText());
            n5 = this.parseInt(this.saveMisc.getText());
        }
        this.setDefaults(n2, n3, n4, n5, this.parseInt(this.saveTemp.getText()));
    }

    private void setDefaults(int n, int n2, int n3, int n4, int n5) {
        this.saveBase.setText(Integer.toString(n));
        this.saveAbility.setText(Integer.toString(n2));
        this.saveMagic.setValue(n3);
        this.saveMisc.setText(Integer.toString(n4));
        this.saveTemp.setValue(n5);
        this.calculate();
    }

    private int getFieldValue(JTextField jTextField) {
        try {
            return Integer.parseInt(jTextField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            jTextField.setText("0");
            return 0;
        }
    }

    private void setSaveType(int n, int n2) {
        this.saveDC.setValue(n);
        if (n2 == 1) {
            this.fortitudeSelection.setSelected(true);
        } else if (n2 == 2) {
            this.reflexSelection.setSelected(true);
        } else if (n2 == 3) {
            this.willSelection.setSelected(true);
        }
    }

    private void setXMLCache(int n) {
        if (this.cbt instanceof XMLCombatant) {
            XMLCombatant xMLCombatant = (XMLCombatant)this.cbt;
            if (this.getSaveType() == 1) {
                xMLCombatant.setSave("Fortitude", n);
            } else if (this.getSaveType() == 2) {
                xMLCombatant.setSave("Reflex", n);
            } else if (this.getSaveType() == 3) {
                xMLCombatant.setSave("Will", n);
            }
        }
    }

    private void calculate() {
        int n = 0;
        n += this.getFieldValue(this.saveBase);
        n += this.getFieldValue(this.saveAbility);
        n += this.getFieldValue(this.saveMagic);
        n += this.getFieldValue(this.saveMisc);
        this.saveTotal.setText(Integer.toString(n += this.getFieldValue(this.saveTemp)));
        this.setXMLCache(n);
    }

    private void roll() {
        int n = this.getFieldValue(this.saveTotal);
        int n2 = this.getFieldValue(this.saveDC);
        int n3 = new Dice(1, 20).roll();
        if (n + n3 >= n2) {
            this.retValue = 1;
            JOptionPane.showMessageDialog(this, this.getSaveAbbrev(this.getSaveType()) + " DC " + n2 + " Passed.  Save: " + n + " + Roll: " + n3 + " = " + (n + n3), "Save Passed", 1);
        } else {
            this.retValue = 2;
            JOptionPane.showMessageDialog(this, this.getSaveAbbrev(this.getSaveType()) + " DC " + n2 + " Failed.  Save: " + n + " + Roll: " + n3 + " = " + (n + n3), "Save Failed", 1);
        }
        this.updateModel();
        this.lastRoll = n3;
        this.setVisible(false);
        this.dispose();
    }

    private JFormattedTextField buildIntegerField(int n, int n2) {
        JFormattedTextField jFormattedTextField = Utils.buildIntegerField(n, n2);
        jFormattedTextField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("value".equals(propertyChangeEvent.getPropertyName())) {
                    SavingThrowDialog.this.calculate();
                }
            }
        });
        return jFormattedTextField;
    }

    private int parseInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private void updateModel() {
        if (this.m_saveModel != null) {
            this.m_saveModel.setDc(this.getFieldValue(this.saveDC));
            if (this.fortitudeSelection.isSelected()) {
                this.m_saveModel.setSaveType("FORTITUDE");
            } else if (this.reflexSelection.isSelected()) {
                this.m_saveModel.setSaveType("REFLEX");
            } else if (this.willSelection.isSelected()) {
                this.m_saveModel.setSaveType("WILL");
            } else {
                this.m_saveModel.setSaveType("NONE");
            }
        }
    }

    public SaveModel getSaveModel() {
        return this.m_saveModel;
    }

    private void initComponents() {
        this.saveTypeGroup = new ButtonGroup();
        this.fortitudeSelection = new JRadioButton();
        this.reflexSelection = new JRadioButton();
        this.willSelection = new JRadioButton();
        this.rollButton = new JButton();
        this.passButton = new JButton();
        this.failButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.characterName = new JLabel();
        this.jLabel9 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.saveTempSlider = Utils.buildSlider(-5, 20);
        this.saveMagicSlider = Utils.buildSlider(-5, 20);
        this.saveDCSlider = Utils.buildSlider(0, 50);
        this.saveBase = this.buildIntegerField(-50, 50);
        this.saveAbility = this.buildIntegerField(-50, 50);
        this.saveMisc = this.buildIntegerField(-50, 50);
        this.saveTotal = this.buildIntegerField(-50, 50);
        this.saveMagic = Utils.buildIntegerFieldWithSlider(this.saveMagicSlider);
        this.saveTemp = Utils.buildIntegerFieldWithSlider(this.saveTempSlider);
        this.saveDC = Utils.buildIntegerFieldWithSlider(this.saveDCSlider);
        this.setTitle("Saving Throw");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SavingThrowDialog.this.closeDialog(windowEvent);
            }
        });
        this.jPanel1.setLayout(new FlowLayout(0));
        this.rollButton.setText("Roll");
        this.rollButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SavingThrowDialog.this.rollButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.rollButton);
        this.passButton.setText("Pass");
        this.passButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SavingThrowDialog.this.passButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.passButton);
        this.failButton.setText("Fail");
        this.failButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SavingThrowDialog.this.failButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.failButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SavingThrowDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.cancelButton);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel1.setText("Base Save");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.jPanel2.add((Component)this.saveBase, gridBagConstraints);
        this.jLabel2.setText("Ability Modifier");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.jPanel2.add((Component)this.saveAbility, gridBagConstraints);
        this.jLabel3.setText("Magic Modifier");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.jPanel2.add((Component)this.saveMagic, gridBagConstraints);
        this.jLabel4.setText("Misc Modifier");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.jPanel2.add((Component)this.saveMisc, gridBagConstraints);
        this.jLabel5.setText("Temp Modifier");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.jPanel2.add((Component)this.saveTemp, gridBagConstraints);
        this.jLabel6.setText("Total");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 10, 5);
        this.jPanel2.add((Component)this.jLabel6, gridBagConstraints);
        this.saveTotal.setBackground(new Color(204, 204, 204));
        this.saveTotal.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.jPanel2.add((Component)this.saveTotal, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 2);
        this.jPanel2.add((Component)this.saveTempSlider, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 2);
        this.jPanel2.add((Component)this.saveMagicSlider, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.saveDC, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 5, 0, 2);
        this.jPanel2.add((Component)this.saveDCSlider, gridBagConstraints);
        this.jLabel7.setText("Difficulty Class");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 5, 0, 5);
        this.jPanel2.add((Component)this.jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.jPanel2.add((Component)this.jLabel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.jPanel2.add((Component)this.jSeparator1, gridBagConstraints);
        this.jLabel9.setText("Save Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel2.add((Component)this.jLabel9, gridBagConstraints);
        this.jPanel3.setLayout(new FlowLayout(0));
        this.fortitudeSelection.setText("Fortitude");
        this.saveTypeGroup.add(this.fortitudeSelection);
        this.fortitudeSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SavingThrowDialog.this.saveSelectedActionPerformed(actionEvent);
            }
        });
        this.jPanel3.add(this.fortitudeSelection);
        this.reflexSelection.setText("Reflex");
        this.saveTypeGroup.add(this.reflexSelection);
        this.reflexSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SavingThrowDialog.this.saveSelectedActionPerformed(actionEvent);
            }
        });
        this.jPanel3.add(this.reflexSelection);
        this.willSelection.setText("Will");
        this.saveTypeGroup.add(this.willSelection);
        this.willSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SavingThrowDialog.this.saveSelectedActionPerformed(actionEvent);
            }
        });
        this.jPanel3.add(this.willSelection);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 2);
        this.jPanel2.add((Component)this.jPanel3, gridBagConstraints);
        this.characterName.setFont(new Font("Dialog", 1, 14));
        this.characterName.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 10, 0);
        this.jPanel2.add((Component)this.characterName, gridBagConstraints);
        this.saveAbility.addKeyListener(new EnterKeyAdapter());
        this.saveBase.addKeyListener(new EnterKeyAdapter());
        this.saveDC.addKeyListener(new EnterKeyAdapter());
        this.saveMagic.addKeyListener(new EnterKeyAdapter());
        this.saveMisc.addKeyListener(new EnterKeyAdapter());
        this.saveTemp.addKeyListener(new EnterKeyAdapter());
        this.saveTotal.addKeyListener(new EnterKeyAdapter());
        this.getContentPane().add((Component)this.jPanel2, "West");
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.retValue = 0;
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void failButtonActionPerformed(ActionEvent actionEvent) {
        this.updateModel();
        this.retValue = 2;
        this.setVisible(false);
        this.dispose();
    }

    private void passButtonActionPerformed(ActionEvent actionEvent) {
        this.updateModel();
        this.retValue = 1;
        this.setVisible(false);
        this.dispose();
    }

    private void rollButtonActionPerformed(ActionEvent actionEvent) {
        this.roll();
    }

    private void saveSelectedActionPerformed(ActionEvent actionEvent) {
        this.setDefaults(this.getSaveType());
    }

    private class EnterKeyAdapter
    extends KeyAdapter {
        private EnterKeyAdapter() {
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                SavingThrowDialog.this.roll();
            }
        }
    }
}

