/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.equipment;

import java.util.ArrayList;
import java.util.Collection;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Equipment;
import pcgen.core.SpecialProperty;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpropToken
extends AbstractToken
implements CDOMPrimaryToken<Equipment> {
    public String getTokenName() {
        return "SPROP";
    }

    public boolean parse(LoadContext loadContext, Equipment equipment, String string) {
        if (this.isEmpty(string) || this.hasIllegalSeparator('|', string)) {
            return false;
        }
        if (".CLEAR".equals(string)) {
            loadContext.getObjectContext().removeList((CDOMObject)equipment, ListKey.SPECIAL_PROPERTIES);
            return true;
        }
        SpecialProperty specialProperty = SpecialProperty.createFromLst((String)string);
        if (specialProperty == null) {
            return false;
        }
        loadContext.getObjectContext().addToList((CDOMObject)equipment, ListKey.SPECIAL_PROPERTIES, (Object)specialProperty);
        return true;
    }

    public String[] unparse(LoadContext loadContext, Equipment equipment) {
        Changes changes = loadContext.getObjectContext().getListChanges((CDOMObject)equipment, ListKey.SPECIAL_PROPERTIES);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Collection collection = changes.getAdded();
        boolean bl = changes.includesGlobalClear();
        if (bl) {
            arrayList.add(".CLEAR");
        }
        if (collection != null && !collection.isEmpty()) {
            for (SpecialProperty specialProperty : collection) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(specialProperty.getDisplayName());
                if (specialProperty.hasPrerequisites()) {
                    stringBuilder.append("|");
                    stringBuilder.append(this.getPrerequisiteString(loadContext, specialProperty.getPrerequisiteList()));
                }
                arrayList.add(stringBuilder.toString());
            }
        }
        if (arrayList.isEmpty()) {
            loadContext.addWriteMessage(this.getTokenName() + " was expecting non-empty changes to include " + "added items or global clear");
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Class<Equipment> getTokenClass() {
        return Equipment.class;
    }
}

