/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.equipment;

import java.util.logging.Level;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.core.Equipment;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeToken
implements CDOMPrimaryToken<Equipment> {
    public String getTokenName() {
        return "RANGE";
    }

    public boolean parse(LoadContext loadContext, Equipment equipment, String string) {
        try {
            Integer n = Integer.valueOf(string);
            if (n < 0) {
                Logging.addParseMessage((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " must be an integer >= 0"));
                return false;
            }
            loadContext.getObjectContext().put((CDOMObject)equipment, IntegerKey.RANGE, n);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            Logging.addParseMessage((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " expected an integer.  Tag must be of the form: " + this.getTokenName() + ":<int>"));
            return false;
        }
    }

    public String[] unparse(LoadContext loadContext, Equipment equipment) {
        Integer n = loadContext.getObjectContext().getInteger((CDOMObject)equipment, IntegerKey.RANGE);
        if (n == null) {
            return null;
        }
        if (n < 0) {
            loadContext.addWriteMessage(this.getTokenName() + " must be an integer >= 0");
            return null;
        }
        return new String[]{n.toString()};
    }

    public Class<Equipment> getTokenClass() {
        return Equipment.class;
    }
}

