/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass.level;

import pcgen.base.formula.AddingFormula;
import pcgen.base.formula.DividingFormula;
import pcgen.base.formula.MultiplyingFormula;
import pcgen.base.formula.ReferenceFormula;
import pcgen.base.formula.SubtractingFormula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.content.HitDie;
import pcgen.cdom.content.Modifier;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.cdom.modifier.HitDieFormula;
import pcgen.cdom.modifier.HitDieLock;
import pcgen.cdom.modifier.HitDieStep;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HitdieLst
extends AbstractToken
implements CDOMPrimaryToken<PCClassLevel> {
    public String getTokenName() {
        return "HITDIE";
    }

    public boolean parse(LoadContext loadContext, PCClassLevel pCClassLevel, String string) {
        try {
            HitDieFormula hitDieFormula;
            String string2 = string;
            int n = string2.indexOf("|");
            if (n != -1) {
                Logging.errorPrint((String)(this.getTokenName() + " is invalid has a pipe: " + string));
                return false;
            }
            if (string2.startsWith("%/")) {
                int n2 = Integer.parseInt(string2.substring(2));
                if (n2 <= 0) {
                    Logging.errorPrint((String)(this.getTokenName() + " was expecting a Positive Integer " + "for dividing Lock, was : " + string2.substring(2)));
                    return false;
                }
                hitDieFormula = new HitDieFormula((ReferenceFormula)new DividingFormula(n2));
            } else if (string2.startsWith("%*")) {
                int n3 = Integer.parseInt(string2.substring(2));
                if (n3 <= 0) {
                    Logging.errorPrint((String)(this.getTokenName() + " was expecting a Positive " + "Integer for multiplying Lock, was : " + string2.substring(2)));
                    return false;
                }
                hitDieFormula = new HitDieFormula((ReferenceFormula)new MultiplyingFormula(n3));
            } else if (string2.startsWith("%+")) {
                int n4 = Integer.parseInt(string2.substring(2));
                if (n4 <= 0) {
                    Logging.errorPrint((String)(this.getTokenName() + " was expecting a Positive " + "Integer for adding Lock, was : " + string2.substring(2)));
                    return false;
                }
                hitDieFormula = new HitDieFormula((ReferenceFormula)new AddingFormula(n4));
            } else if (string2.startsWith("%-")) {
                int n5 = Integer.parseInt(string2.substring(2));
                if (n5 <= 0) {
                    Logging.errorPrint((String)(this.getTokenName() + " was expecting a Positive " + "Integer for subtracting Lock, was : " + string2.substring(2)));
                    return false;
                }
                hitDieFormula = new HitDieFormula((ReferenceFormula)new SubtractingFormula(n5));
            } else if (string2.startsWith("%up")) {
                int n6 = Integer.parseInt(string2.substring(3));
                if (n6 <= 0) {
                    Logging.errorPrint((String)("Invalid Step Count: " + n6 + " in " + this.getTokenName() + " up (must be positive)"));
                    return false;
                }
                if (n6 >= 5) {
                    Logging.errorPrint((String)("Invalid Step Count: " + n6 + " in " + this.getTokenName() + " up (too large)"));
                    return false;
                }
                hitDieFormula = new HitDieStep(n6, new HitDie(12));
            } else if (string2.startsWith("%Hup")) {
                int n7 = Integer.parseInt(string2.substring(4));
                if (n7 <= 0) {
                    Logging.errorPrint((String)("Invalid Step Count: " + n7 + " in " + this.getTokenName()));
                    return false;
                }
                hitDieFormula = new HitDieStep(n7, null);
            } else if (string2.startsWith("%down")) {
                int n8 = Integer.parseInt(string2.substring(5));
                if (n8 <= 0) {
                    Logging.errorPrint((String)("Invalid Step Count: " + n8 + " in " + this.getTokenName() + " down (must be positive)"));
                    return false;
                }
                if (n8 >= 5) {
                    Logging.errorPrint((String)("Invalid Step Count: " + n8 + " in " + this.getTokenName() + " down (too large)"));
                    return false;
                }
                hitDieFormula = new HitDieStep(-n8, new HitDie(4));
            } else if (string2.startsWith("%Hdown")) {
                int n9 = Integer.parseInt(string2.substring(6));
                if (n9 <= 0) {
                    Logging.errorPrint((String)("Invalid Step Count: " + n9 + " in " + this.getTokenName()));
                    return false;
                }
                hitDieFormula = new HitDieStep(-n9, null);
            } else {
                int n10 = Integer.parseInt(string2);
                if (n10 <= 0) {
                    Logging.errorPrint((String)("Invalid HitDie: " + n10 + " in " + this.getTokenName()));
                    return false;
                }
                hitDieFormula = new HitDieLock(new HitDie(n10));
            }
            loadContext.getObjectContext().put((CDOMObject)pCClassLevel, ObjectKey.HITDIE, (Object)hitDieFormula);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint((String)("Invalid Number in " + this.getTokenName() + ": " + numberFormatException.getLocalizedMessage()));
            Logging.errorPrint((String)"  Must be an Integer");
            return false;
        }
    }

    public String[] unparse(LoadContext loadContext, PCClassLevel pCClassLevel) {
        Modifier modifier = (Modifier)loadContext.getObjectContext().getObject((CDOMObject)pCClassLevel, ObjectKey.HITDIE);
        if (modifier == null) {
            return null;
        }
        return new String[]{modifier.getLSTformat()};
    }

    public Class<PCClassLevel> getTokenClass() {
        return PCClassLevel.class;
    }
}

