/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.spell;

import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.SettingsHandler;
import pcgen.core.spell.Spell;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchoolToken
extends AbstractToken
implements CDOMPrimaryToken<Spell> {
    public String getTokenName() {
        return "SCHOOL";
    }

    public boolean parse(LoadContext loadContext, Spell spell, String string) {
        if (this.isEmpty(string) || this.hasIllegalSeparator('|', string)) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (".CLEAR".equals(string2)) {
                if (!bl) {
                    Logging.errorPrint((String)("  Non-sensical " + this.getTokenName() + ": .CLEAR was not the first list item: " + string));
                    return false;
                }
                loadContext.getObjectContext().removeList((CDOMObject)spell, ListKey.SPELL_SCHOOL);
            } else {
                loadContext.getObjectContext().addToList((CDOMObject)spell, ListKey.SPELL_SCHOOL, (Object)string2);
                SettingsHandler.getGame().addToSchoolList(string2);
            }
            bl = false;
        }
        return true;
    }

    public String[] unparse(LoadContext loadContext, Spell spell) {
        Changes changes = loadContext.getObjectContext().getListChanges((CDOMObject)spell, ListKey.SPELL_SCHOOL);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (changes.includesGlobalClear()) {
            stringBuilder.append(".CLEAR");
        }
        if (changes.hasAddedItems()) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append((CharSequence)StringUtil.joinToStringBuffer((Collection)changes.getAdded(), (String)"|"));
        }
        return new String[]{stringBuilder.toString()};
    }

    public Class<Spell> getTokenClass() {
        return Spell.class;
    }
}

