/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit.skill;

import java.math.BigDecimal;
import pcgen.core.kit.KitSkill;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RankToken
extends AbstractToken
implements CDOMSecondaryToken<KitSkill> {
    public String getTokenName() {
        return "RANK";
    }

    public Class<KitSkill> getTokenClass() {
        return KitSkill.class;
    }

    public String getParentToken() {
        return "*KITTOKEN";
    }

    public boolean parse(LoadContext loadContext, KitSkill kitSkill, String string) {
        if (this.isEmpty(string)) {
            return false;
        }
        try {
            BigDecimal bigDecimal = new BigDecimal(string);
            if (bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
                Logging.errorPrint((String)(this.getTokenName() + " must be a positive number: " + string));
                return false;
            }
            kitSkill.setRank(bigDecimal);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint((String)(this.getTokenName() + " expected a number: " + string));
            return false;
        }
    }

    public String[] unparse(LoadContext loadContext, KitSkill kitSkill) {
        BigDecimal bigDecimal = kitSkill.getRank();
        if (bigDecimal == null) {
            return null;
        }
        return new String[]{bigDecimal.toString()};
    }
}

