/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.ant;

import com.vladium.emma.ant.PropertyElement;
import com.vladium.emma.ant.SuppressableTask;
import com.vladium.util.Property;
import com.vladium.util.XProperties;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class GenericCfg {
    private final Task m_task;
    private final List m_genericPropertyElements;
    private File m_settingsFile;
    private transient Properties m_fileSettings;
    private transient Properties m_genericSettings;

    public GenericCfg(Task task) {
        if (task == null) {
            throw new IllegalArgumentException("null input: task");
        }
        this.m_task = task;
        this.m_genericPropertyElements = new ArrayList();
    }

    public void setProperties(File file) {
        this.m_settingsFile = file;
    }

    public PropertyElement createProperty() {
        this.m_genericSettings = null;
        PropertyElement property = new PropertyElement();
        this.m_genericPropertyElements.add(property);
        return property;
    }

    public Properties getFileSettings() {
        Properties fileSettings = this.m_fileSettings;
        if (fileSettings == null && this.m_settingsFile != null) {
            try {
                this.m_fileSettings = fileSettings = Property.getPropertiesFromFile((File)this.m_settingsFile);
            }
            catch (IOException ioe) {
                throw (BuildException)SuppressableTask.newBuildException(this.m_task.getTaskName() + ": property file [" + this.m_settingsFile.getAbsolutePath() + "] could not be read", ioe, this.m_task.getLocation()).fillInStackTrace();
            }
        }
        return fileSettings;
    }

    public Properties getGenericSettings() {
        Properties genericSettings = this.m_genericSettings;
        if (genericSettings == null) {
            genericSettings = new XProperties();
            Iterator i = this.m_genericPropertyElements.iterator();
            while (i.hasNext()) {
                String value;
                PropertyElement property = (PropertyElement)i.next();
                String name = property.getName();
                String string = value = property.getValue() != null ? property.getValue() : "";
                if (name == null) continue;
                genericSettings.setProperty(name, value);
            }
            this.m_genericSettings = genericSettings;
        }
        return genericSettings;
    }
}

