/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.spell;

import java.math.BigDecimal;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.spell.Spell;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CostToken
extends AbstractToken
implements CDOMPrimaryToken<Spell> {
    public String getTokenName() {
        return "COST";
    }

    public boolean parse(LoadContext loadContext, Spell spell, String string) {
        if (this.isEmpty(string)) {
            return false;
        }
        try {
            BigDecimal bigDecimal = new BigDecimal(string);
            if (bigDecimal.compareTo(BigDecimal.ZERO) <= 0) {
                Logging.errorPrint((String)(this.getTokenName() + " requires a positive Integer"));
                return false;
            }
            loadContext.getObjectContext().put((CDOMObject)spell, ObjectKey.COST, (Object)bigDecimal);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint((String)(this.getTokenName() + " expected an integer.  Tag must be of the form: " + this.getTokenName() + ":<int>"));
            return false;
        }
    }

    public String[] unparse(LoadContext loadContext, Spell spell) {
        BigDecimal bigDecimal = (BigDecimal)loadContext.getObjectContext().getObject((CDOMObject)spell, ObjectKey.COST);
        if (bigDecimal == null) {
            return null;
        }
        if (bigDecimal.compareTo(BigDecimal.ZERO) <= 0) {
            loadContext.addWriteMessage(this.getTokenName() + " requires a positive Integer");
            return null;
        }
        return new String[]{bigDecimal.toString()};
    }

    public Class<Spell> getTokenClass() {
        return Spell.class;
    }
}

