/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.parser;

import pcgen.core.GameMode;
import pcgen.core.SettingsHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteOperator;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.AbstractPrerequisiteParser;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;

public class PreAlignParser
extends AbstractPrerequisiteParser
implements PrerequisiteParserInterface {
    public String[] kindsHandled() {
        return new String[]{"align"};
    }

    public Prerequisite parse(String string, String string2, boolean bl, boolean bl2) throws PersistenceLayerException {
        Prerequisite prerequisite = super.parse(string, string2, bl, bl2);
        String[] stringArray = string2.split(",");
        GameMode gameMode = SettingsHandler.getGame();
        if (gameMode == null) {
            prerequisite.setKey("");
            prerequisite.setOperator(PrerequisiteOperator.EQ);
            return prerequisite;
        }
        String[] stringArray2 = gameMode.getAlignmentListStrings(false);
        if (stringArray2.length == 0) {
            prerequisite.setKey("");
            prerequisite.setOperator(PrerequisiteOperator.EQ);
        } else if (stringArray.length == 1) {
            prerequisite.setKey(this.convertFromNumber(string2, stringArray2));
            prerequisite.setOperator(PrerequisiteOperator.EQ);
        } else {
            prerequisite.setKind(null);
            prerequisite.setOperator(PrerequisiteOperator.GTEQ);
            prerequisite.setOperand("1");
            for (int i = 0; i < stringArray.length; ++i) {
                Prerequisite prerequisite2 = new Prerequisite();
                prerequisite2.setKind("align");
                prerequisite2.setKey(this.convertFromNumber(stringArray[i], stringArray2));
                prerequisite2.setOperator(PrerequisiteOperator.EQ);
                prerequisite.addPrerequisite(prerequisite2);
            }
        }
        if (bl) {
            prerequisite.setOperator(prerequisite.getOperator().invert());
        }
        return prerequisite;
    }

    private String convertFromNumber(String string, String[] stringArray) {
        try {
            int n = Integer.parseInt(string);
            return stringArray[n];
        }
        catch (NumberFormatException numberFormatException) {
            return string;
        }
    }
}

