/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.renderer.BaseInputControl;
import org.lobobrowser.util.gui.WrapperLayout;

abstract class BaseInputTextControl
extends BaseInputControl {
    private static final float DEFAULT_FONT_SIZE = 14.0f;
    protected final JTextComponent widget;
    private int maxLength = -1;

    public BaseInputTextControl(HTMLBaseInputElement modelNode) {
        super(modelNode);
        this.setLayout(WrapperLayout.getInstance());
        JTextComponent widget = this.createTextField();
        Font font = widget.getFont();
        widget.setFont(font.deriveFont(14.0f));
        widget.setDocument(new LimitedDocument());
        this.widget = widget;
        this.add(widget);
    }

    public void reset(int availWidth, int availHeight) {
        super.reset(availWidth, availHeight);
        HTMLElementImpl element = this.controlElement;
        String value = element.getAttribute("value");
        this.widget.setText(value);
        String maxLengthText = this.controlElement.getAttribute("maxlength");
        if (maxLengthText != null) {
            try {
                this.maxLength = Integer.parseInt(maxLengthText);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
    }

    protected abstract JTextComponent createTextField();

    public int getMaxLength() {
        return this.maxLength;
    }

    public boolean getReadOnly() {
        return !this.widget.isEditable();
    }

    public String getValue() {
        return this.widget.getText();
    }

    public void select() {
        this.widget.selectAll();
    }

    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
        this.widget.setEnabled(!disabled);
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setReadOnly(boolean readOnly) {
        this.widget.setEditable(!readOnly);
    }

    public void setValue(String value) {
        this.widget.setText(value);
    }

    public Dimension getPreferredSize() {
        int size = this.size;
        JTextComponent widget = this.widget;
        FontMetrics fm = widget.getFontMetrics(widget.getFont());
        Insets insets = widget.getInsets();
        int pw = size == -1 ? 100 : insets.left + insets.right + fm.charWidth('0') * size;
        int ph = fm.getHeight() + insets.top + insets.bottom;
        return new Dimension(pw, ph);
    }

    public void resetInput() {
        this.widget.setText("");
    }

    private class LimitedDocument
    extends PlainDocument {
        private LimitedDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            int max = BaseInputTextControl.this.maxLength;
            if (max != -1) {
                int docLength = this.getLength();
                if (docLength >= max) {
                    return;
                }
                int strLen = str.length();
                if (docLength + strLen > max) {
                    String shorterStr = str.substring(0, max - docLength);
                    super.insertString(offs, shorterStr, a);
                } else {
                    super.insertString(offs, str, a);
                }
            } else {
                super.insertString(offs, str, a);
            }
        }
    }
}

