/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import org.lobobrowser.html.renderer.FloatingBounds;
import org.lobobrowser.util.Objects;

class FloatingViewportBounds
implements FloatingBounds {
    private final FloatingBounds prevBounds;
    private final int alignment;
    private final int y;
    private final int width;
    private final int height;

    public FloatingViewportBounds(FloatingBounds prevBounds, int alignment, int y, int width, int height) {
        this.prevBounds = prevBounds;
        this.alignment = alignment;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public int getLeft(int y) {
        int left = 0;
        FloatingBounds prev = this.prevBounds;
        if (prev != null) {
            left = prev.getLeft(y);
        }
        if (this.alignment < 0 && y >= this.y && y < this.y + this.height) {
            left += this.width;
        }
        return left;
    }

    public int getRight(int y) {
        int right = 0;
        FloatingBounds prev = this.prevBounds;
        if (prev != null) {
            right = prev.getRight(y);
        }
        if (this.alignment > 0 && y >= this.y && y < this.y + this.height) {
            right += this.width;
        }
        return right;
    }

    public int getClearY(int y) {
        int pcy;
        int cleary = Math.max(y, this.y + this.height);
        FloatingBounds prev = this.prevBounds;
        if (prev != null && (pcy = prev.getClearY(y)) > cleary) {
            cleary = pcy;
        }
        return cleary;
    }

    public boolean equals(Object other) {
        if (!(other instanceof FloatingViewportBounds)) {
            return false;
        }
        FloatingViewportBounds olm = (FloatingViewportBounds)other;
        return olm.alignment == this.alignment && olm.y == this.y && olm.height == this.height && olm.width == this.width && Objects.equals(olm.prevBounds, this.prevBounds);
    }
}

