/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JScrollBar;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.domimpl.NodeFilter;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.renderer.BaseElementRenderable;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.FloatingBounds;
import org.lobobrowser.html.renderer.FloatingViewportBounds;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.HtmlController;
import org.lobobrowser.html.renderer.RBlockViewport;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.renderer.SizeExceededException;
import org.lobobrowser.html.style.BlockRenderState;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.util.Objects;
import org.w3c.dom.Node;
import org.w3c.dom.html2.HTMLBodyElement;

public class RBlock
extends BaseElementRenderable
implements RenderableContainer,
ImageObserver {
    static final Logger logger = Logger.getLogger(RBlock.class.getName());
    private static final boolean loggableInfo = logger.isLoggable(Level.INFO);
    private static final FloatingBounds INVALID_FLOAT_BOUNDS = new FloatingViewportBounds(null, 0, 0, 0, 0);
    protected final FrameContext frameContext;
    protected final int listNesting;
    protected final HtmlRendererContext rendererContext;
    protected final int defaultOverflow;
    protected final RBlockViewport bodyLayout;
    protected RenderableSpot startSelection;
    protected RenderableSpot endSelection;
    protected JScrollBar vScrollBar;
    protected JScrollBar hScrollBar;
    protected boolean hasHScrollBar = false;
    protected boolean hasVScrollBar = false;
    private Boolean lastExpandWidth = null;
    private Boolean lastExpandHeight = null;
    private int lastAvailHeight = -1;
    private int lastAvailWidth = -1;
    private int lastWhiteSpace = -1;
    private FloatingBounds lastFloatBounds = INVALID_FLOAT_BOUNDS;
    private Font lastFont = null;
    private Insets defaultPaddingInsets = null;
    private boolean resettingScrollBars = false;
    private BoundableRenderable armedRenderable;

    public RBlock(NodeImpl modelNode, int listNesting, UserAgentContext pcontext, HtmlRendererContext rcontext, FrameContext frameContext, RenderableContainer parentContainer) {
        this(modelNode, listNesting, pcontext, rcontext, frameContext, parentContainer, 0);
    }

    public RBlock(NodeImpl modelNode, int listNesting, UserAgentContext pcontext, HtmlRendererContext rcontext, FrameContext frameContext, RenderableContainer parentContainer, int defaultOverflow) {
        super(parentContainer, modelNode, pcontext);
        RBlockViewport bl;
        this.listNesting = listNesting;
        this.frameContext = frameContext;
        this.rendererContext = rcontext;
        this.defaultOverflow = defaultOverflow;
        this.bodyLayout = bl = new RBlockViewport(modelNode, this, this.getViewportListNesting(listNesting), pcontext, rcontext, frameContext, this);
        bl.setOriginalParent(this);
        bl.setX(Short.MAX_VALUE);
        bl.setY(Short.MAX_VALUE);
    }

    public int getVScrollBarWidth() {
        return 16;
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    public int getVAlign() {
        return 5;
    }

    public void ensureVisible(Point point) {
        RBlockViewport bodyLayout = this.bodyLayout;
        if (bodyLayout != null) {
            boolean hscroll = this.hasHScrollBar;
            boolean vscroll = this.hasVScrollBar;
            int origX = bodyLayout.x;
            int origY = bodyLayout.y;
            Insets insets = this.getInsets(hscroll, vscroll);
            if (hscroll) {
                if (point.x < insets.left) {
                    bodyLayout.x += insets.left - point.x;
                } else if (point.x > this.width - insets.right) {
                    bodyLayout.x -= point.x - this.width + insets.right;
                }
            }
            if (vscroll) {
                if (point.y < insets.top) {
                    bodyLayout.y += insets.top - point.y;
                } else if (point.y > this.height - insets.bottom) {
                    bodyLayout.y -= point.y - this.height + insets.bottom;
                }
            }
            if (hscroll || vscroll) {
                this.correctViewportOrigin(insets, this.width, this.height);
                if (origX != bodyLayout.x || origY != bodyLayout.y) {
                    this.resetScrollBars(null);
                    this.repaint();
                }
            }
        }
    }

    private JScrollBar getHScrollBar() {
        JScrollBar sb = this.hScrollBar;
        if (sb == null) {
            sb = new JScrollBar(0);
            sb.addAdjustmentListener(new LocalAdjustmentListener(0));
            this.hScrollBar = sb;
        }
        return sb;
    }

    private JScrollBar getVScrollBar() {
        JScrollBar sb = this.vScrollBar;
        if (sb == null) {
            sb = new JScrollBar(1);
            sb.addAdjustmentListener(new LocalAdjustmentListener(1));
            this.vScrollBar = sb;
        }
        return sb;
    }

    public final boolean couldBeScrollable() {
        int overflow = this.getOverflow();
        return overflow != 0 && (overflow == 1 || overflow == 5 || overflow == 2);
    }

    public void setDefaultPaddingInsets(Insets insets) {
        this.defaultPaddingInsets = insets;
    }

    public void setDefaultMarginInsets(Insets insets) {
        this.defaultMarginInsets = insets;
    }

    public int getFirstLineHeight() {
        return this.bodyLayout.getFirstLineHeight();
    }

    public void setSelectionEnd(RenderableSpot rpoint) {
        this.endSelection = rpoint;
    }

    public void setSelectionStart(RenderableSpot rpoint) {
        this.startSelection = rpoint;
    }

    protected final Insets getPaddingInsets(RenderState rs) {
        Insets mi = rs.getPaddingInsets();
        if (mi == null) {
            return this.defaultPaddingInsets;
        }
        return mi;
    }

    public int getViewportListNesting(int blockNesting) {
        return blockNesting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        long time4;
        long time3;
        long time2;
        long time1;
        boolean linfo;
        block23: {
            linfo = loggableInfo;
            time1 = linfo ? System.currentTimeMillis() : 0L;
            this.prePaint(g);
            time2 = linfo ? System.currentTimeMillis() : 0L;
            time3 = 0L;
            try {
                JScrollBar vsb;
                JScrollBar hsb;
                Insets insets = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
                RBlockViewport bodyLayout = this.bodyLayout;
                if (bodyLayout != null) {
                    int overflow = this.getOverflow();
                    if (overflow == 0 || overflow == 4) {
                        int bx = bodyLayout.x;
                        int by = bodyLayout.y;
                        g.translate(bx, by);
                        try {
                            bodyLayout.paint(g);
                        }
                        finally {
                            g.translate(-bx, -by);
                        }
                    }
                    Graphics newG = g.create(insets.left, insets.top, this.width - insets.left - insets.right, this.height - insets.top - insets.bottom);
                    try {
                        newG.translate(bodyLayout.x - insets.left, bodyLayout.y - insets.top);
                        bodyLayout.paint(newG);
                    }
                    finally {
                        newG.dispose();
                    }
                    if (linfo) {
                        time3 = System.currentTimeMillis();
                    }
                }
                RenderableSpot start = this.startSelection;
                RenderableSpot end = this.endSelection;
                boolean inSelection = false;
                if (start != null && end != null && !start.equals(end)) {
                    this.paintSelection(g, inSelection, start, end);
                }
                if ((hsb = this.hScrollBar) != null) {
                    Graphics sbg = g.create(insets.left, this.height - insets.bottom, this.width - insets.left - insets.right, 16);
                    try {
                        hsb.paint(sbg);
                    }
                    finally {
                        sbg.dispose();
                    }
                }
                if ((vsb = this.vScrollBar) == null) break block23;
                Graphics sbg = g.create(this.width - insets.right, insets.top, 16, this.height - insets.top - insets.bottom);
                try {
                    vsb.paint(sbg);
                }
                finally {
                    sbg.dispose();
                }
            }
            finally {
                super.paint(g);
            }
        }
        if (linfo && (time4 = System.currentTimeMillis()) - time1 > 100L) {
            logger.info("paint(): Elapsed: " + (time4 - time1) + " ms. Prepaint: " + (time2 - time1) + " ms. Viewport: " + (time3 - time2) + " ms. RBlock: " + this + ".");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dimension doCellLayout(int width, int height, boolean expandWidth, boolean expandHeight) {
        try {
            this.doLayout(width, height, expandWidth, expandHeight);
            Dimension dimension = new Dimension(this.width, this.height);
            return dimension;
        }
        finally {
            this.layoutUpTreeCanBeInvalidated = true;
        }
    }

    public final void layout(int availWidth, int availHeight, boolean expandWidth, boolean expandHeight, int defaultOverflow) {
        this.layout(availWidth, availHeight, expandWidth, expandHeight, null, 0, defaultOverflow);
    }

    public final void layout(int availWidth, int availHeight, boolean expandWidth, boolean expandHeight, FloatingBounds floatBounds, int tentativeY) {
        this.layout(availWidth, availHeight, expandWidth, expandHeight, floatBounds, tentativeY, this.defaultOverflow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void layout(int availWidth, int availHeight, boolean expandWidth, boolean expandHeight, FloatingBounds floatBounds, int tentativeY, int defaultOverflow) {
        try {
            this.doLayout(availWidth, availHeight, expandWidth, expandHeight, floatBounds, tentativeY, defaultOverflow);
        }
        finally {
            this.layoutUpTreeCanBeInvalidated = true;
            this.layoutDeepCanBeInvalidated = true;
        }
    }

    public final void doLayout(int availWidth, int availHeight, boolean expandWidth, boolean expandHeight) {
        this.doLayout(availWidth, availHeight, expandWidth, expandHeight, null, 0, this.defaultOverflow);
    }

    public final void doLayout(int availWidth, int availHeight, boolean expandWidth, boolean expandHeight, int tentativeY) {
        this.doLayout(availWidth, availHeight, expandWidth, expandHeight, null, tentativeY, this.defaultOverflow);
    }

    public void doLayout(int availWidth, int availHeight, boolean expandWidth, boolean expandHeight, FloatingBounds floatBounds, int tentativeY, int defaultOverflow) {
        boolean forced;
        int prevAvailWidth = this.lastAvailWidth;
        int prevAvailHeight = this.lastAvailHeight;
        RenderState renderState = this.modelNode.getRenderState();
        boolean bl = forced = availHeight != prevAvailHeight || availWidth != prevAvailWidth || !Boolean.valueOf(expandWidth).equals(this.lastExpandWidth) || !Boolean.valueOf(expandHeight).equals(this.lastExpandHeight);
        if (!forced) {
            if (renderState != null) {
                Font font = renderState.getFont();
                if (!font.equals(this.lastFont)) {
                    forced = true;
                } else {
                    int newWhiteSpace = renderState.getWhiteSpace();
                    if (newWhiteSpace != this.lastWhiteSpace) {
                        forced = true;
                    }
                }
            }
            if (!forced) {
                if (this.lastFloatBounds == INVALID_FLOAT_BOUNDS) {
                    forced = true;
                } else {
                    boolean bl2 = forced = !Objects.equals(this.lastFloatBounds, floatBounds);
                }
            }
        }
        if (forced) {
            this.forceLayout(renderState, availWidth, availHeight, expandWidth, expandHeight, floatBounds, tentativeY, defaultOverflow);
        }
        this.sendGUIComponentsToParent();
        this.sendDelayedPairsToParent();
    }

    private final boolean correctViewportOrigin(Insets insets, int blockWidth, int blockHeight) {
        RBlockViewport bodyLayout = this.bodyLayout;
        int viewPortX = bodyLayout.x;
        int viewPortY = bodyLayout.y;
        boolean corrected = false;
        if (viewPortX > insets.left) {
            bodyLayout.x = insets.left;
            corrected = true;
        } else if (viewPortX < blockWidth - insets.right - bodyLayout.width) {
            bodyLayout.x = Math.min(insets.left, blockWidth - insets.right - bodyLayout.width);
            corrected = true;
        }
        if (viewPortY > insets.top) {
            bodyLayout.y = insets.top;
            corrected = true;
        } else if (viewPortY < blockHeight - insets.bottom - bodyLayout.height) {
            bodyLayout.y = Math.min(insets.top, blockHeight - insets.bottom - bodyLayout.height);
            corrected = true;
        }
        return corrected;
    }

    private final void forceLayout(RenderState renderState, int availWidth, int availHeight, boolean expandWidth, boolean expandHeight, FloatingBounds floatBounds, int tentativeY, int defaultOverflow) {
        JScrollBar sb;
        int resultingHeight;
        int resultingWidth;
        boolean visible;
        int tries;
        boolean bothScrollBars;
        Insets marginInsets;
        Font newFont;
        RenderState rs = renderState;
        if (rs == null) {
            rs = new BlockRenderState(null, null);
        }
        if (this.lastAvailWidth == -1) {
            rs.invalidate();
            this.applyStyle();
        }
        int dw = this.getDeclaredWidth(rs, availWidth);
        int dh = this.getDeclaredHeight(rs, availHeight);
        this.lastExpandHeight = expandHeight;
        this.lastExpandWidth = expandWidth;
        this.lastFont = newFont = rs.getFont();
        this.lastAvailHeight = availHeight;
        this.lastAvailWidth = availWidth;
        this.lastFloatBounds = floatBounds;
        this.lastWhiteSpace = rs.getWhiteSpace();
        RBlockViewport bodyLayout = this.bodyLayout;
        NodeImpl node = (NodeImpl)this.modelNode;
        if (node == null || bodyLayout == null) {
            Insets insets = this.getInsets(false, false);
            this.width = insets.left + insets.right;
            this.height = insets.bottom + insets.top;
            this.hasHScrollBar = false;
            this.hasVScrollBar = false;
            return;
        }
        this.clearGUIComponents();
        if ((dw != -1 || dh != -1) && (marginInsets = this.getMarginInsets(rs)) != null) {
            dw = dw == -1 ? -1 : dw + marginInsets.left + marginInsets.right;
            dh = dh == -1 ? -1 : dh + marginInsets.top + marginInsets.bottom;
        }
        int tentativeWidth = dw == -1 ? availWidth : dw;
        int tentativeHeight = dh == -1 ? availHeight : dh;
        int overflow = this.getOverflow();
        if (overflow == 0) {
            overflow = defaultOverflow;
        }
        boolean vertical = overflow == 5;
        boolean auto = vertical || overflow == 2;
        boolean hscroll = bothScrollBars = overflow == 1;
        boolean vscroll = bothScrollBars || vertical;
        boolean mayScroll = auto || bothScrollBars || vertical;
        Insets paddingInsets = this.getPaddingInsets(rs);
        if (paddingInsets == null) {
            paddingInsets = RBlockViewport.ZERO_INSETS;
        }
        Insets insets = null;
        int n = tries = auto && !vscroll ? 0 : 1;
        while (tries < 2) {
            try {
                insets = this.getInsets(hscroll, vscroll);
                int maxY = tries == 0 ? (dh == -1 ? -1 : dh - insets.bottom - insets.top - paddingInsets.bottom) : -1;
                int desiredViewportWidth = tentativeWidth - insets.left - insets.right;
                int desiredViewportHeight = tentativeHeight - insets.top - insets.bottom;
                bodyLayout.layout(desiredViewportWidth, desiredViewportHeight, paddingInsets, node, maxY, floatBounds);
                break;
            }
            catch (SizeExceededException hee) {
                if (tries != 0) {
                    throw new IllegalStateException("tries=" + tries + ",auto=" + auto);
                }
                vscroll = true;
                ++tries;
            }
        }
        this.hasVScrollBar = vscroll;
        Dimension size = bodyLayout.getSize();
        Dimension rblockSize = new Dimension(size.width + insets.left + insets.right, size.height + insets.top + insets.bottom);
        if (auto && !hscroll && (dw != -1 && rblockSize.width > dw || rblockSize.width > availWidth)) {
            hscroll = true;
            insets = this.getInsets(hscroll, vscroll);
            rblockSize = new Dimension(size.width + insets.left + insets.right, size.height + insets.top + insets.bottom);
        }
        this.hasHScrollBar = hscroll;
        boolean bl = visible = !auto && !bothScrollBars && overflow != 3;
        if (dw == -1) {
            resultingWidth = rblockSize.width;
            if (expandWidth && resultingWidth < availWidth) {
                resultingWidth = availWidth;
            } else if (hscroll && resultingWidth > availWidth) {
                resultingWidth = Math.max(availWidth, 16);
            }
        } else {
            int n2 = resultingWidth = visible ? Math.max(rblockSize.width, dw) : dw;
        }
        if (dh == -1) {
            resultingHeight = rblockSize.height;
            if (expandHeight && resultingHeight < availHeight) {
                resultingHeight = availHeight;
            } else if (vscroll && resultingHeight > availHeight) {
                resultingHeight = Math.max(availHeight, 16);
            }
        } else {
            int n3 = resultingHeight = visible ? Math.max(rblockSize.height, dh) : dh;
        }
        if (vscroll) {
            sb = this.getVScrollBar();
            this.add(sb);
        }
        if (hscroll) {
            sb = this.getHScrollBar();
            this.add(sb);
        }
        this.width = resultingWidth;
        this.height = resultingHeight;
        int alignmentXPercent = rs.getAlignXPercent();
        int alignmentYPercent = rs.getAlignYPercent();
        if (alignmentXPercent > 0 || alignmentYPercent > 0) {
            int canvasWidth = Math.max(bodyLayout.width, resultingWidth - insets.left - insets.right);
            int canvasHeight = Math.max(bodyLayout.height, resultingHeight - insets.top - insets.bottom);
            bodyLayout.align(alignmentXPercent, alignmentYPercent, canvasWidth, canvasHeight, paddingInsets);
        }
        if (hscroll || vscroll) {
            this.correctViewportOrigin(insets, resultingWidth, resultingHeight);
            this.resetScrollBars(rs);
        } else {
            bodyLayout.x = insets.left;
            bodyLayout.y = insets.top;
        }
    }

    private int getVUnitIncrement(RenderState renderState) {
        if (renderState != null) {
            return renderState.getFontMetrics().getHeight();
        }
        return new BlockRenderState(null, null).getFontMetrics().getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetScrollBars(RenderState renderState) {
        this.resettingScrollBars = true;
        try {
            RBlockViewport bodyLayout = this.bodyLayout;
            if (bodyLayout != null) {
                JScrollBar hsb;
                Insets insets = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
                JScrollBar vsb = this.vScrollBar;
                if (vsb != null) {
                    int newValue = insets.top - bodyLayout.y;
                    int newExtent = this.height - insets.top - insets.bottom;
                    int newMin = 0;
                    int newMax = bodyLayout.height;
                    vsb.setValues(newValue, newExtent, newMin, newMax);
                    vsb.setUnitIncrement(this.getVUnitIncrement(renderState));
                    vsb.setBlockIncrement(newExtent);
                }
                if ((hsb = this.hScrollBar) != null) {
                    int newValue = insets.left - bodyLayout.x;
                    int newExtent = this.width - insets.left - insets.right;
                    int newMin = 0;
                    int newMax = bodyLayout.width;
                    hsb.setValues(newValue, newExtent, newMin, newMax);
                }
            }
        }
        finally {
            this.resettingScrollBars = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean paintSelection(Graphics g, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        Graphics newG = g.create();
        try {
            Insets insets = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
            newG.clipRect(insets.left, insets.top, this.width - insets.left - insets.right, this.height - insets.top - insets.bottom);
            boolean bl = super.paintSelection(newG, inSelection, startPoint, endPoint);
            return bl;
        }
        finally {
            newG.dispose();
        }
    }

    public RenderableSpot getLowestRenderableSpot(int x, int y) {
        RBlockViewport bodyLayout = this.bodyLayout;
        if (bodyLayout != null) {
            Insets insets = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
            if (x > insets.left && x < this.width - insets.right && y > insets.top && y < this.height - insets.bottom) {
                return bodyLayout.getLowestRenderableSpot(x - bodyLayout.x, y - bodyLayout.y);
            }
            return new RenderableSpot(this, x, y);
        }
        return new RenderableSpot(this, x, y);
    }

    public void invalidateLayoutLocal() {
        super.invalidateLayoutLocal();
        this.lastAvailHeight = -1;
        this.lastAvailWidth = -1;
        this.lastWhiteSpace = -1;
        this.lastExpandHeight = null;
        this.lastExpandWidth = null;
        this.lastFloatBounds = INVALID_FLOAT_BOUNDS;
    }

    public boolean onMouseClick(MouseEvent event, int x, int y) {
        RBlockViewport bodyLayout = this.bodyLayout;
        if (bodyLayout != null && !bodyLayout.onMouseClick(event, x - bodyLayout.x, y - bodyLayout.y)) {
            return false;
        }
        if (!HtmlController.getInstance().onMouseClick(this.modelNode, event, x, y)) {
            return false;
        }
        return this.backgroundColor == null;
    }

    public boolean onDoubleClick(MouseEvent event, int x, int y) {
        RBlockViewport bodyLayout = this.bodyLayout;
        if (bodyLayout != null && !bodyLayout.onDoubleClick(event, x - bodyLayout.x, y - bodyLayout.y)) {
            return false;
        }
        return this.backgroundColor == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onMouseDisarmed(MouseEvent event) {
        BoundableRenderable br = this.armedRenderable;
        if (br != null) {
            try {
                boolean bl = br.onMouseDisarmed(event);
                return bl;
            }
            finally {
                this.armedRenderable = null;
            }
        }
        return true;
    }

    public boolean onMousePressed(MouseEvent event, int x, int y) {
        RBlockViewport bodyLayout = this.bodyLayout;
        if (bodyLayout != null) {
            int newX = x - bodyLayout.x;
            int newY = y - bodyLayout.y;
            if (bodyLayout.contains(newX, newY)) {
                this.armedRenderable = bodyLayout;
                if (!bodyLayout.onMousePressed(event, newX, newY)) {
                    return false;
                }
            } else {
                this.armedRenderable = null;
            }
        } else {
            this.armedRenderable = null;
        }
        if (!HtmlController.getInstance().onMouseDown(this.modelNode, event, x, y)) {
            return false;
        }
        return this.backgroundColor == null;
    }

    public boolean onMouseReleased(MouseEvent event, int x, int y) {
        RBlockViewport bodyLayout = this.bodyLayout;
        if (bodyLayout != null) {
            int newX = x - bodyLayout.x;
            int newY = y - bodyLayout.y;
            if (bodyLayout.contains(newX, newY)) {
                this.armedRenderable = null;
                if (!bodyLayout.onMouseReleased(event, newX, newY)) {
                    return false;
                }
            } else {
                BoundableRenderable br = this.armedRenderable;
                if (br != null) {
                    br.onMouseDisarmed(event);
                }
            }
        }
        if (!HtmlController.getInstance().onMouseUp(this.modelNode, event, x, y)) {
            return false;
        }
        return this.backgroundColor == null;
    }

    public Color getPaintedBackgroundColor() {
        return this.backgroundColor;
    }

    public Iterator getRenderables() {
        final RBlockViewport bodyLayout = this.bodyLayout;
        return new Iterator(){
            private RBlockViewport bl;
            {
                this.bl = bodyLayout;
            }

            public boolean hasNext() {
                return this.bl != null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object next() {
                if (this.bl == null) {
                    throw new NoSuchElementException();
                }
                try {
                    RBlockViewport rBlockViewport = this.bl;
                    return rBlockViewport;
                }
                finally {
                    this.bl = null;
                }
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void repaint(ModelNode modelNode) {
        this.repaint();
    }

    public void updateWidgetBounds(int guiX, int guiY) {
        super.updateWidgetBounds(guiX, guiY);
        boolean hscroll = this.hasHScrollBar;
        boolean vscroll = this.hasVScrollBar;
        if (hscroll || vscroll) {
            JScrollBar vsb;
            JScrollBar hsb;
            Insets insets = this.getInsets(hscroll, vscroll);
            if (hscroll && (hsb = this.hScrollBar) != null) {
                hsb.setBounds(guiX + insets.left, guiY + this.height - insets.bottom, this.width - insets.left - insets.right, 16);
            }
            if (vscroll && (vsb = this.vScrollBar) != null) {
                vsb.setBounds(guiX + this.width - insets.right, guiY + insets.top, 16, this.height - insets.top - insets.bottom);
            }
        }
    }

    public void scrollHorizontalTo(int newX) {
        RBlockViewport bodyLayout = this.bodyLayout;
        if (bodyLayout != null) {
            Insets insets = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
            int viewPortX = newX;
            bodyLayout.x = viewPortX > insets.left ? insets.left : (viewPortX < this.width - insets.right - bodyLayout.width ? Math.min(insets.left, this.width - insets.right - bodyLayout.width) : viewPortX);
            this.resetScrollBars(null);
            this.updateWidgetBounds();
            this.repaint();
        }
    }

    public void scrollVerticalTo(int newY) {
        RBlockViewport bodyLayout = this.bodyLayout;
        if (bodyLayout != null) {
            Insets insets = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
            int viewPortY = newY;
            bodyLayout.y = viewPortY > insets.top ? insets.top : (viewPortY < this.height - insets.bottom - bodyLayout.height ? Math.min(insets.top, this.height - insets.bottom - bodyLayout.height) : viewPortY);
            this.resetScrollBars(null);
            this.updateWidgetBounds();
            this.repaint();
        }
    }

    public void scrollByUnits(int orientation, int units) {
        int offset = orientation == 1 ? this.getVUnitIncrement(null) * units : units;
        this.scrollBy(orientation, offset);
    }

    public void scrollBy(int orientation, int offset) {
        RBlockViewport bodyLayout = this.bodyLayout;
        if (bodyLayout != null) {
            switch (orientation) {
                case 0: {
                    this.scrollHorizontalTo(bodyLayout.x - offset);
                    break;
                }
                case 1: {
                    this.scrollVerticalTo(bodyLayout.y - offset);
                }
            }
        }
    }

    private void scrollToSBValue(int orientation, int value) {
        Insets insets = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
        switch (orientation) {
            case 0: {
                int xOrigin = insets.left - value;
                this.scrollHorizontalTo(xOrigin);
                break;
            }
            case 1: {
                int yOrigin = insets.top - value;
                this.scrollVerticalTo(yOrigin);
            }
        }
    }

    public RBlockViewport getRBlockViewport() {
        return this.bodyLayout;
    }

    public String toString() {
        return "RBlock[node=" + this.modelNode + "]";
    }

    private static class BodyFilter
    implements NodeFilter {
        private BodyFilter() {
        }

        public boolean accept(Node node) {
            return node instanceof HTMLBodyElement;
        }
    }

    private class LocalAdjustmentListener
    implements AdjustmentListener {
        private final int orientation;

        public LocalAdjustmentListener(int orientation) {
            this.orientation = orientation;
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (RBlock.this.resettingScrollBars) {
                return;
            }
            switch (e.getAdjustmentType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    int value = e.getValue();
                    RBlock.this.scrollToSBValue(this.orientation, value);
                    break;
                }
            }
        }
    }
}

