/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.domimpl.UINode;
import org.lobobrowser.html.renderer.BaseElementRenderable;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.HtmlController;
import org.lobobrowser.html.renderer.RBlockViewport;
import org.lobobrowser.html.renderer.RElement;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.renderer.UIControl;
import org.lobobrowser.html.style.RenderState;

class RUIControl
extends BaseElementRenderable
implements RElement {
    public final UIControl widget;
    private final ModelNode modelNode;
    private final FrameContext frameContext;
    private int lastAvailWidth = -1;
    private int lastAvailHeight = -1;
    private int declaredWidth = -1;
    private int declaredHeight = -1;

    public RUIControl(ModelNode me, UIControl widget, RenderableContainer container, FrameContext frameContext, UserAgentContext ucontext) {
        super(container, me, ucontext);
        this.modelNode = me;
        this.widget = widget;
        this.frameContext = frameContext;
        widget.setRUIControl(this);
    }

    public void focus() {
        super.focus();
        Component c = this.widget.getComponent();
        c.requestFocus();
    }

    public final void invalidateLayoutLocal() {
        super.invalidateLayoutLocal();
        this.widget.invalidate();
        this.lastAvailHeight = -1;
        this.lastAvailWidth = -1;
    }

    public int getVAlign() {
        return this.widget.getVAlign();
    }

    public final void paint(Graphics g) {
        this.widget.paint(g);
        super.paint(g);
    }

    public boolean onMouseClick(MouseEvent event, int x, int y) {
        ModelNode me = this.modelNode;
        if (me != null) {
            return HtmlController.getInstance().onMouseClick(me, event, x, y);
        }
        return true;
    }

    public boolean onDoubleClick(MouseEvent event, int x, int y) {
        ModelNode me = this.modelNode;
        if (me != null) {
            return HtmlController.getInstance().onDoubleClick(me, event, x, y);
        }
        return true;
    }

    public boolean onMousePressed(MouseEvent event, int x, int y) {
        ModelNode me = this.modelNode;
        if (me != null) {
            return HtmlController.getInstance().onMouseDown(me, event, x, y);
        }
        return true;
    }

    public boolean onMouseReleased(MouseEvent event, int x, int y) {
        ModelNode me = this.modelNode;
        if (me != null) {
            return HtmlController.getInstance().onMouseUp(me, event, x, y);
        }
        return true;
    }

    public boolean onMouseDisarmed(MouseEvent event) {
        ModelNode me = this.modelNode;
        if (me != null) {
            return HtmlController.getInstance().onMouseDisarmed(me, event);
        }
        return true;
    }

    public void invalidateRenderStyle() {
    }

    public void repaint(ModelNode modelNode) {
        UIControl widget = this.widget;
        if (widget instanceof UINode) {
            ((UINode)((Object)widget)).repaint(modelNode);
        } else {
            this.repaint();
        }
    }

    public void updateWidgetBounds(int guiX, int guiY) {
        super.updateWidgetBounds(guiX, guiY);
        this.widget.setBounds(guiX, guiY, this.width, this.height);
    }

    public Color getBlockBackgroundColor() {
        return this.widget.getBackgroundColor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean paintSelection(Graphics g, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        Color over;
        if ((inSelection = super.paintSelection(g, inSelection, startPoint, endPoint)) && (over = new Color(0, 0, 255, 50)) != null) {
            Color oldColor = g.getColor();
            try {
                g.setColor(over);
                g.fillRect(0, 0, this.width, this.height);
            }
            finally {
                g.setColor(oldColor);
            }
        }
        return inSelection;
    }

    public boolean extractSelectionText(StringBuffer buffer, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        return inSelection;
    }

    public RenderableSpot getLowestRenderableSpot(int x, int y) {
        return new RenderableSpot(this, x, y);
    }

    public void doLayout(int availWidth, int availHeight, boolean expandWidth, boolean expandHeight) {
        if (availWidth != this.lastAvailWidth || availHeight != this.lastAvailHeight) {
            this.applyStyle();
            this.lastAvailWidth = availWidth;
            this.lastAvailHeight = availHeight;
            UIControl widget = this.widget;
            widget.reset(availWidth, availHeight);
            RenderState renderState = this.modelNode.getRenderState();
            int dw = this.getDeclaredWidth(renderState, availWidth);
            int dh = this.getDeclaredHeight(renderState, availHeight);
            this.declaredWidth = dw;
            this.declaredHeight = dh;
            if (dw == -1 || dh == -1) {
                Dimension size = widget.getPreferredSize();
                if (dw == -1) {
                    dw = size.width;
                }
                if (dh == -1) {
                    dh = size.height;
                }
            }
            this.width = dw;
            this.height = dh;
        }
    }

    public final void preferredSizeInvalidated() {
        int dw = this.declaredWidth;
        int dh = this.declaredHeight;
        if (dw == -1 || dh == -1) {
            this.frameContext.delayedRelayout((NodeImpl)this.modelNode);
        } else {
            this.repaint();
        }
    }

    public Iterator getRenderables() {
        return null;
    }

    public Color getPaintedBackgroundColor() {
        return this.container.getPaintedBackgroundColor();
    }

    public Insets getInsets() {
        return RBlockViewport.ZERO_INSETS;
    }
}

