/*
 * Decompiled with CFR 0.152.
 */
package gmgen;

import gmgen.GMGenSystemView;
import gmgen.gui.PreferencesDialog;
import gmgen.gui.PreferencesRootTreeNode;
import gmgen.pluginmgr.GMBComponent;
import gmgen.pluginmgr.GMBMessage;
import gmgen.pluginmgr.GMBus;
import gmgen.pluginmgr.PluginLoader;
import gmgen.pluginmgr.messages.ClipboardMessage;
import gmgen.pluginmgr.messages.FetchOpenPCGRequestMessage;
import gmgen.pluginmgr.messages.FileOpenMessage;
import gmgen.pluginmgr.messages.LoadMessage;
import gmgen.pluginmgr.messages.PCLoadedMessage;
import gmgen.pluginmgr.messages.PreferencesPanelAddMessage;
import gmgen.pluginmgr.messages.SaveMessage;
import gmgen.pluginmgr.messages.StateChangedMessage;
import gmgen.pluginmgr.messages.TabAddMessage;
import gmgen.pluginmgr.messages.ToolMenuItemAddMessage;
import gmgen.pluginmgr.messages.WindowClosedMessage;
import gmgen.util.LogUtilities;
import gmgen.util.MiscUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.lang.reflect.Method;
import java.util.EventObject;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import pcgen.core.SettingsHandler;
import pcgen.util.Logging;
import pcgen.util.SwingWorker;

public final class GMGenSystem
extends JFrame
implements ChangeListener,
MenuListener,
ActionListener,
GMBComponent {
    public static GMGenSystem inst;
    public static final boolean MAC_OS_X;
    public JMenuItem copyEditItem;
    public JMenuItem cutEditItem;
    public JMenuItem newFileItem;
    public JMenuItem openFileItem;
    public JMenuItem pasteEditItem;
    public JMenuItem preferencesEditItem;
    public JMenuItem saveFileItem;
    private GMGenSystemView theView;
    private JMenu editMenu;
    private JMenu fileMenu;
    private JMenu toolsMenu;
    private JMenuBar systemMenu;
    private JMenuItem exitFileItem;
    private JMenuItem versionToolsItem;
    private JSeparator editSeparator1;
    private JSeparator fileSeparator1;
    private JSeparator fileSeparator2;
    private JSeparator toolsSeparator1;
    private PreferencesRootTreeNode rootNode = new PreferencesRootTreeNode();

    public GMGenSystem() {
        super("GMGen System");
        new Renderer().start();
    }

    private void initialize() {
        if (MAC_OS_X) {
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
            System.setProperty("com.apple.mrj.application.live-resize", "false");
            System.setProperty("com.apple.macos.smallTabs", "true");
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "GMGen");
            this.macOSXRegistration();
        }
        inst = this;
        this.initLogger();
        this.createMenuBar();
        this.theView = new GMGenSystemView();
        GMBus.addToBus(this);
        PluginLoader pluginLoader = PluginLoader.inst();
        pluginLoader.startSystemPlugins("GMGen");
        this.initComponents();
        this.initSettings();
        GMBus.send(new FetchOpenPCGRequestMessage(this));
        GMBus.send(new StateChangedMessage(this, this.editMenu));
        inst.setVisible(true);
    }

    public static String getBuild() {
        return "03.03.99.01.00";
    }

    public static String getVersion() {
        return MiscUtilities.buildToVersion(GMGenSystem.getBuild());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.openFileItem) {
            GMBus.send(new FileOpenMessage(this));
        } else if (actionEvent.getSource() == this.exitFileItem) {
            GMBus.send(new WindowClosedMessage(this));
        } else if (actionEvent.getSource() == this.newFileItem) {
            GMBus.send(new LoadMessage(this));
        } else if (actionEvent.getSource() == this.saveFileItem) {
            GMBus.send(new SaveMessage(this));
        } else if (actionEvent.getSource() == this.cutEditItem) {
            GMBus.send(new ClipboardMessage(this, 0));
        } else if (actionEvent.getSource() == this.copyEditItem) {
            GMBus.send(new ClipboardMessage(this, 1));
        } else if (actionEvent.getSource() == this.pasteEditItem) {
            GMBus.send(new ClipboardMessage(this, 2));
        }
    }

    public void clearEditMenu() {
        this.editMenu.removeAll();
        if (!MAC_OS_X) {
            this.editMenu.add(this.editSeparator1);
            this.preferencesEditItem.setText("Preferences");
            this.editMenu.add(this.preferencesEditItem);
            this.preferencesEditItem.setEnabled(true);
            ActionListener[] actionListenerArray = this.preferencesEditItem.getActionListeners();
            for (int i = 0; i < actionListenerArray.length; ++i) {
                this.preferencesEditItem.removeActionListener(actionListenerArray[i]);
            }
            this.preferencesEditItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GMGenSystem.this.mPreferencesActionPerformed(actionEvent);
                }
            });
        }
    }

    public void exitFormMac() {
        this.setVisible(false);
    }

    public void handleFileMenu() {
    }

    public void handleMessage(GMBMessage gMBMessage) {
        if (gMBMessage instanceof TabAddMessage) {
            TabAddMessage tabAddMessage = (TabAddMessage)gMBMessage;
            if (tabAddMessage.getSystem().equals("GMGen")) {
                Logging.debugPrint("Creating Tab " + GMGenSystemView.getTabPane().getTabCount());
                this.theView.insertPane(tabAddMessage.getName(), tabAddMessage.getPane(), GMGenSystemView.getTabPane().getTabCount());
            }
        } else if (gMBMessage instanceof PreferencesPanelAddMessage) {
            PreferencesPanelAddMessage preferencesPanelAddMessage = (PreferencesPanelAddMessage)gMBMessage;
            Logging.debugPrint("Creating Preferences Panel");
            this.rootNode.addPanel(preferencesPanelAddMessage.getName(), preferencesPanelAddMessage.getPane());
        } else if (gMBMessage instanceof ToolMenuItemAddMessage) {
            ToolMenuItemAddMessage toolMenuItemAddMessage = (ToolMenuItemAddMessage)gMBMessage;
            this.toolsMenu.add(toolMenuItemAddMessage.getMenuItem());
        } else if (gMBMessage instanceof WindowClosedMessage) {
            this.setCloseSettings();
            this.exitForm(null);
        } else if (gMBMessage instanceof PCLoadedMessage) {
            // empty if block
        }
    }

    public void handleToolsMenu() {
    }

    public void mPreferencesActionPerformedMac() {
        PreferencesDialog preferencesDialog = new PreferencesDialog((Frame)this, true, this.rootNode);
        preferencesDialog.setVisible(true);
    }

    public void macOSXRegistration() {
        if (MAC_OS_X) {
            try {
                Object object;
                Class<?> clazz = Class.forName("gmgen.util.OSXAdapter");
                Class[] classArray = new Class[]{GMGenSystem.class};
                Method method = clazz.getDeclaredMethod("registerMacOSXApplication", classArray);
                if (method != null) {
                    object = new Object[]{this};
                    method.invoke(clazz, object);
                }
                classArray[0] = Boolean.TYPE;
                object = clazz.getDeclaredMethod("enablePrefs", classArray);
                if (object != null) {
                    Object[] objectArray = new Object[]{Boolean.TRUE};
                    object.invoke(clazz, objectArray);
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                System.err.println("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + noClassDefFoundError + ")");
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + classNotFoundException + ")");
            }
            catch (Exception exception) {
                System.err.println("Exception while loading the OSXAdapter:");
                exception.printStackTrace();
            }
        }
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuSelected(MenuEvent menuEvent) {
        if (menuEvent.getSource() == this.fileMenu) {
            this.handleFileMenu();
        } else if (menuEvent.getSource() == this.toolsMenu) {
            this.handleToolsMenu();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.stateUpdate(changeEvent);
    }

    public void stateUpdate(EventObject eventObject) {
        this.newFileItem.setEnabled(false);
        this.openFileItem.setEnabled(false);
        this.saveFileItem.setEnabled(false);
        this.clearEditMenu();
        GMBus.send(new StateChangedMessage(this, this.editMenu));
    }

    private void setCloseSettings() {
        SettingsHandler.setGMGenOption("WindowX", this.getX());
        SettingsHandler.setGMGenOption("WindowY", this.getY());
        SettingsHandler.setGMGenOption("WindowWidth", this.getSize().width);
        SettingsHandler.setGMGenOption("WindowHeight", this.getSize().height);
        if ((this.getExtendedState() & 6) != 0) {
            SettingsHandler.setGMGenOption("WindowState", 6);
        } else if ((this.getExtendedState() & 2) != 0) {
            SettingsHandler.setGMGenOption("WindowState", 2);
        } else if ((this.getExtendedState() & 4) != 0) {
            SettingsHandler.setGMGenOption("WindowState", 4);
        } else {
            SettingsHandler.setGMGenOption("WindowState", 0);
        }
    }

    private void setTabbedPanes() {
        try {
            GMGenSystemView.getTabPane().setSelectedIndex(0);
            this.theView.showPane();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createMenuBar() {
        this.systemMenu = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newFileItem = new JMenuItem();
        this.openFileItem = new JMenuItem();
        this.fileSeparator1 = new JSeparator();
        this.saveFileItem = new JMenuItem();
        this.fileSeparator2 = new JSeparator();
        this.exitFileItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.cutEditItem = new JMenuItem();
        this.copyEditItem = new JMenuItem();
        this.pasteEditItem = new JMenuItem();
        this.editSeparator1 = new JSeparator();
        this.preferencesEditItem = new JMenuItem();
        this.toolsMenu = new JMenu();
        this.toolsSeparator1 = new JSeparator();
        this.versionToolsItem = new JMenuItem();
        this.fileMenu.setText("File");
        this.fileMenu.setMnemonic('F');
        this.fileMenu.addMenuListener(this);
        this.newFileItem.setMnemonic('N');
        this.newFileItem.setText("New");
        this.newFileItem.addActionListener(this);
        this.fileMenu.add(this.newFileItem);
        this.openFileItem.setMnemonic('O');
        this.openFileItem.setText("Open");
        this.fileMenu.add(this.openFileItem);
        this.openFileItem.addActionListener(this);
        this.fileMenu.add(this.fileSeparator1);
        this.saveFileItem.setMnemonic('S');
        this.saveFileItem.setText("Save");
        this.fileMenu.add(this.saveFileItem);
        this.saveFileItem.addActionListener(this);
        if (!MAC_OS_X) {
            this.fileMenu.add(this.fileSeparator2);
            this.exitFileItem.setMnemonic('x');
            this.exitFileItem.setText("Exit");
            this.fileMenu.add(this.exitFileItem);
            this.exitFileItem.addActionListener(this);
        }
        this.systemMenu.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.editMenu.setMnemonic('E');
        this.editMenu.addMenuListener(this);
        this.cutEditItem.setText("Cut");
        this.editMenu.add(this.cutEditItem);
        this.copyEditItem.setText("Copy");
        this.editMenu.add(this.copyEditItem);
        this.pasteEditItem.setText("Paste");
        this.editMenu.add(this.pasteEditItem);
        if (!MAC_OS_X) {
            this.editMenu.add(this.editSeparator1);
            this.preferencesEditItem.setText("Preferences");
            this.editMenu.add(this.preferencesEditItem);
            this.preferencesEditItem.setEnabled(true);
            ActionListener[] actionListenerArray = this.preferencesEditItem.getActionListeners();
            for (int i = 0; i < actionListenerArray.length; ++i) {
                this.preferencesEditItem.removeActionListener(actionListenerArray[i]);
            }
            this.preferencesEditItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GMGenSystem.this.mPreferencesActionPerformed(actionEvent);
                }
            });
        }
        this.systemMenu.add(this.editMenu);
        this.toolsMenu.setText("Tools");
        this.toolsMenu.setMnemonic('T');
        this.toolsMenu.addMenuListener(this);
        this.versionToolsItem.setMnemonic('G');
        this.versionToolsItem.setText("Get Newest Version");
        this.toolsMenu.add(this.versionToolsItem);
        this.toolsMenu.add(this.toolsSeparator1);
        this.systemMenu.add(this.toolsMenu);
        this.setJMenuBar(this.systemMenu);
        this.openFileItem.setEnabled(true);
        this.saveFileItem.setEnabled(false);
        this.newFileItem.setEnabled(false);
        this.cutEditItem.setEnabled(false);
        this.copyEditItem.setEnabled(false);
        this.pasteEditItem.setEnabled(false);
        this.preferencesEditItem.setEnabled(true);
        this.versionToolsItem.setEnabled(false);
        this.pack();
    }

    private void exitForm(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    private void initComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        this.setTabbedPanes();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GMGenSystem.this.exitForm(windowEvent);
            }
        });
        this.addWindowFocusListener(new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent windowEvent) {
                GMGenSystem.this.stateUpdate(windowEvent);
            }

            public void windowLostFocus(WindowEvent windowEvent) {
            }
        });
        GMGenSystemView.getTabPane().addChangeListener(this);
        this.getContentPane().add((Component)this.theView, "Center");
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(this.getClass().getResource("/pcgen/gui/resource/gmgen_icon.png"));
        this.setIconImage(image);
    }

    private void initLogger() {
        LogUtilities.inst().setLoggingOn(SettingsHandler.getGMGenOption("Logging.On", false));
    }

    private void initSettings() {
        int n = SettingsHandler.getGMGenOption("WindowX", 0);
        int n2 = SettingsHandler.getGMGenOption("WindowY", 0);
        this.setLocation(n, n2);
        int n3 = SettingsHandler.getGMGenOption("WindowWidth", 750);
        int n4 = SettingsHandler.getGMGenOption("WindowHeight", 580);
        this.setSize(n3, n4);
        int n5 = SettingsHandler.getGMGenOption("WindowState", 0);
        if (n5 != 0) {
            this.setExtendedState(n5);
        }
    }

    private void mPreferencesActionPerformed(ActionEvent actionEvent) {
        PreferencesDialog preferencesDialog = new PreferencesDialog((Frame)this, true, this.rootNode);
        preferencesDialog.setVisible(true);
    }

    static {
        MAC_OS_X = System.getProperty("os.name").equals("Mac OS X");
    }

    private class Renderer
    extends SwingWorker {
        private Renderer() {
        }

        public Object construct() {
            return "";
        }

        public void finished() {
            GMGenSystem.this.initialize();
        }
    }
}

