/*
 * Decompiled with CFR 0.152.
 */
package gmgen.pluginmgr;

import gmgen.pluginmgr.ErrorListDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class ErrorListCellRenderer
extends JComponent
implements ListCellRenderer {
    private Font boldFont;
    private Font plainFont = UIManager.getFont("Label.font");
    private FontMetrics boldFM;
    private FontMetrics plainFM;
    private String path;
    private String[] messages;

    public ErrorListCellRenderer() {
        this.boldFont = new Font(this.plainFont.getName(), 1, this.plainFont.getSize());
        this.plainFM = this.getFontMetrics(this.plainFont);
        this.boldFM = this.getFontMetrics(this.boldFont);
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        ErrorListDialog.ErrorEntry errorEntry = (ErrorListDialog.ErrorEntry)object;
        this.path = errorEntry.path + ":";
        this.messages = errorEntry.messages;
        return this;
    }

    public Dimension getPreferredSize() {
        int n = this.boldFM.stringWidth(this.path);
        int n2 = this.boldFM.getHeight();
        for (int i = 0; i < this.messages.length; ++i) {
            n = Math.max(this.plainFM.stringWidth(this.messages[i]), n);
            n2 += this.plainFM.getHeight();
        }
        Insets insets = this.getBorder().getBorderInsets(this);
        return new Dimension(n += insets.left + insets.right, n2 += insets.top + insets.bottom);
    }

    public void paintComponent(Graphics graphics) {
        Insets insets = this.getBorder().getBorderInsets(this);
        graphics.setFont(this.boldFont);
        graphics.drawString(this.path, insets.left, insets.top + this.boldFM.getAscent());
        int n = insets.top + this.boldFM.getHeight() + 2;
        graphics.setFont(this.plainFont);
        for (String string : this.messages) {
            graphics.drawString(string, insets.left, n + this.plainFM.getAscent());
            n += this.plainFM.getHeight();
        }
    }
}

