/*
 * Decompiled with CFR 0.152.
 */
package gmgen.pluginmgr;

import gmgen.pluginmgr.GMBPlugin;
import gmgen.pluginmgr.GMBus;
import gmgen.pluginmgr.JARClassLoader;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import pcgen.core.SettingsHandler;

public abstract class Plugin {
    private JAR jar;

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getDataDir() {
        String string = SettingsHandler.getGmgenPluginDir().toString();
        return string + File.separator + this.getName();
    }

    public JAR getJAR() {
        return this.jar;
    }

    public String getName() {
        return null;
    }

    public String getVersion() {
        return null;
    }

    public void start() {
    }

    public void stop() {
    }

    public abstract String getPluginSystem();

    public abstract int getPluginLoadOrder();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PluginComperator
    implements Comparator<Plugin>,
    Serializable {
        @Override
        public int compare(Plugin plugin, Plugin plugin2) {
            Integer n = plugin.getPluginLoadOrder();
            Integer n2 = plugin2.getPluginLoadOrder();
            System.out.println(plugin.getName() + ": " + plugin.getPluginLoadOrder() + " - " + plugin2.getName() + ": " + plugin2.getPluginLoadOrder());
            return n2.compareTo(n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JAR {
        private JARClassLoader classLoader;
        private String path;
        private List<Plugin> plugins;

        public JAR(String string, JARClassLoader jARClassLoader) {
            this.path = string;
            this.classLoader = jARClassLoader;
            this.plugins = new ArrayList<Plugin>();
        }

        public JARClassLoader getClassLoader() {
            return this.classLoader;
        }

        public String getPath() {
            return this.path;
        }

        public void getPlugins(List<Plugin> list) {
            list.addAll(this.plugins);
        }

        public void addPlugin(Plugin plugin) {
            plugin.jar = this;
            plugin.start();
            if (plugin instanceof GMBPlugin) {
                GMBus.addToBus((GMBPlugin)plugin);
            }
            this.plugins.add(plugin);
        }
    }

    public static class Broken
    extends Plugin {
        private String clazz;

        Broken(String string) {
            this.clazz = string;
        }

        public String getClassName() {
            return this.clazz;
        }

        public String getPluginSystem() {
            return "Broken";
        }

        public int getPluginLoadOrder() {
            return 0;
        }
    }
}

