/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pcgen.base.util.MapToList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMapToList<K, V>
implements MapToList<K, V> {
    protected final Map<K, List<V>> mapToList;

    protected AbstractMapToList(Map<K, List<V>> map) {
        this.mapToList = map;
    }

    public void initializeListFor(K k) {
        if (this.mapToList.containsKey(k)) {
            throw new IllegalArgumentException("Cannot re-initialize key: " + k);
        }
        this.mapToList.put(k, new ArrayList());
    }

    @Override
    public void addToListFor(K k, V v) {
        if (!this.containsListFor(k)) {
            this.initializeListFor(k);
        }
        this.mapToList.get(k).add(v);
    }

    @Override
    public void addAllToListFor(K k, Collection<V> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        if (!this.containsListFor(k)) {
            this.initializeListFor(k);
        }
        this.mapToList.get(k).addAll(collection);
    }

    @Override
    public void addAllLists(MapToList<K, V> mapToList) {
        for (K k : mapToList.getKeySet()) {
            this.addAllToListFor(k, mapToList.getListFor(k));
        }
    }

    @Override
    public boolean containsListFor(K k) {
        return this.mapToList.containsKey(k);
    }

    @Override
    public boolean containsInList(K k, V v) {
        return this.containsListFor(k) && this.mapToList.get(k).contains(v);
    }

    @Override
    public int sizeOfListFor(K k) {
        List<V> list = this.mapToList.get(k);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    @Override
    public List<V> getListFor(K k) {
        List<V> list = this.mapToList.get(k);
        return list == null ? null : new ArrayList<V>(list);
    }

    @Override
    public boolean removeFromListFor(K k, V v) {
        List<V> list = this.mapToList.get(k);
        if (list == null) {
            return false;
        }
        boolean bl = list.remove(v);
        if (bl && list.isEmpty()) {
            this.mapToList.remove(k);
        }
        return bl;
    }

    @Override
    public List<V> removeListFor(K k) {
        return this.mapToList.remove(k);
    }

    @Override
    public boolean isEmpty() {
        return this.mapToList.isEmpty();
    }

    @Override
    public int size() {
        return this.mapToList.size();
    }

    @Override
    public V getElementInList(K k, int n) {
        List<V> list = this.mapToList.get(k);
        if (list == null) {
            throw new IllegalArgumentException(k + " is not a key in this AbstractMapToList");
        }
        return list.get(n);
    }

    @Override
    public void clear() {
        this.mapToList.clear();
    }

    public String toString() {
        return this.mapToList.toString();
    }

    @Override
    public Set<K> getKeySet() {
        Set<K> set = this.getEmptySet();
        set.addAll(this.mapToList.keySet());
        return set;
    }

    protected abstract Set<K> getEmptySet();

    public int hashCode() {
        return ((Object)this.mapToList).hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof AbstractMapToList) {
            return ((Object)this.mapToList).equals(((AbstractMapToList)object).mapToList);
        }
        if (object instanceof MapToList) {
            MapToList mapToList = (MapToList)object;
            Set<K> set = this.mapToList.keySet();
            if (((Object)set).equals(mapToList.getKeySet())) {
                for (K k : set) {
                    if (((Object)this.mapToList.get(k)).equals(mapToList.getListFor(k))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

