/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.util;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListSet<T>
extends AbstractSet<T>
implements Set<T> {
    private final Comparator<T> comparator;
    private final ArrayList<T> list;

    public ListSet() {
        this(10, null);
    }

    public ListSet(int n) {
        this(n, null);
    }

    public ListSet(Comparator<T> comparator) {
        this(10, comparator);
    }

    public ListSet(int n, Comparator<T> comparator) {
        this.list = new ArrayList(n);
        this.comparator = comparator;
    }

    public ListSet(Collection<T> collection) {
        this.list = new ArrayList<T>(collection);
        this.comparator = null;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public boolean add(T t) {
        boolean bl = false;
        if (this.comparator == null) {
            bl = this.list.contains(t);
        } else {
            Iterator<T> iterator = this.list.iterator();
            while (iterator.hasNext()) {
                if (this.comparator.compare(iterator.next(), t) != 0) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            return this.list.add(t);
        }
        return false;
    }

    public void ensureCapacity(int n) {
        this.list.ensureCapacity(n);
    }

    public void trimToSize() {
        this.list.trimToSize();
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean contains(Object object) {
        if (this.comparator == null) {
            return this.list.contains(object);
        }
        Object object2 = object;
        Iterator<T> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            if (this.comparator.compare(object2, iterator.next()) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean remove(Object object) {
        if (this.comparator == null) {
            return this.list.remove(object);
        }
        Object object2 = object;
        Iterator<T> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            if (this.comparator.compare(object2, iterator.next()) != 0) continue;
            iterator.remove();
            return true;
        }
        return false;
    }
}

