/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import pcgen.base.util.ListSet;
import pcgen.cdom.base.PrereqObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcretePrereqObject
implements Cloneable,
PrereqObject {
    private Set<Prerequisite> thePrereqs = null;

    public boolean qualifies(PlayerCharacter playerCharacter) {
        if (this.thePrereqs == null) {
            return true;
        }
        return PrereqHandler.passesAll(this.thePrereqs, playerCharacter, null);
    }

    @Override
    public List<Prerequisite> getPrerequisiteList() {
        if (this.thePrereqs == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<Prerequisite>(this.thePrereqs));
    }

    public final void addPreReq(Prerequisite prerequisite, int n) {
        if (prerequisite == null) {
            return;
        }
        if ("clear".equals(prerequisite.getKind())) {
            this.thePrereqs = null;
        } else {
            if (this.thePrereqs == null) {
                this.thePrereqs = new ListSet<Prerequisite>();
            }
            if (n > 0) {
                prerequisite.setLevelQualifier(n);
            }
            this.thePrereqs.add(prerequisite);
        }
    }

    public final boolean hasPreReqTypeOf(String string) {
        if (!this.hasPrerequisites()) {
            return false;
        }
        for (Prerequisite prerequisite : this.getPrerequisiteList()) {
            if (!PrerequisiteUtilities.hasPreReqKindOf(prerequisite, string)) continue;
            return true;
        }
        return false;
    }

    public ConcretePrereqObject clone() throws CloneNotSupportedException {
        ConcretePrereqObject concretePrereqObject = (ConcretePrereqObject)super.clone();
        if (this.thePrereqs != null) {
            concretePrereqObject.thePrereqs = new ListSet<Prerequisite>();
            concretePrereqObject.thePrereqs.addAll(this.thePrereqs);
        }
        return concretePrereqObject;
    }

    @Override
    public void addAllPrerequisites(Collection<Prerequisite> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        if (this.thePrereqs == null) {
            this.thePrereqs = new ListSet<Prerequisite>(collection.size());
        }
        for (Prerequisite prerequisite : collection) {
            this.addPrerequisite(prerequisite);
        }
    }

    @Override
    public void addPrerequisite(Prerequisite prerequisite) {
        this.addPreReq(prerequisite, -1);
    }

    @Override
    public void clearPrerequisiteList() {
        this.thePrereqs = null;
    }

    @Override
    public int getPrerequisiteCount() {
        if (this.thePrereqs == null) {
            return 0;
        }
        return this.thePrereqs.size();
    }

    @Override
    public boolean hasPrerequisites() {
        return this.thePrereqs != null;
    }

    public boolean equalsPrereqObject(PrereqObject prereqObject) {
        if (this == prereqObject) {
            return true;
        }
        boolean bl = prereqObject.hasPrerequisites();
        if (!this.hasPrerequisites()) {
            return !bl;
        }
        if (!bl) {
            return false;
        }
        List<Prerequisite> list = prereqObject.getPrerequisiteList();
        if (list.size() != this.thePrereqs.size()) {
            return false;
        }
        ArrayList<Prerequisite> arrayList = new ArrayList<Prerequisite>(this.thePrereqs);
        arrayList.removeAll(list);
        return arrayList.isEmpty();
    }
}

