/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.choiceset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.ChoiceSet;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellCasterChoiceSet
extends ChoiceSet<PCClass>
implements PrimitiveChoiceSet<PCClass> {
    private static final PrimitiveChoiceSet<PCClass> EMPTY_CHOICE_SET = new PrimitiveChoiceSet<PCClass>(){

        @Override
        public Class<PCClass> getChoiceClass() {
            return PCClass.class;
        }

        @Override
        public String getLSTformat(boolean bl) {
            return "";
        }

        @Override
        public Set<PCClass> getSet(PlayerCharacter playerCharacter) {
            return Collections.emptySet();
        }
    };
    private final CDOMGroupRef<PCClass> allClasses;
    private final List<String> spelltypes;
    private final PrimitiveChoiceSet<PCClass> pcset;
    private final PrimitiveChoiceSet<PCClass> primitives;

    public SpellCasterChoiceSet(CDOMGroupRef<PCClass> cDOMGroupRef, List<String> list, PrimitiveChoiceSet<PCClass> primitiveChoiceSet, PrimitiveChoiceSet<PCClass> primitiveChoiceSet2) {
        super("SPELLCASTER", primitiveChoiceSet == null ? EMPTY_CHOICE_SET : primitiveChoiceSet);
        this.pcset = primitiveChoiceSet;
        this.primitives = primitiveChoiceSet2;
        this.spelltypes = new ArrayList<String>(list);
        this.allClasses = cDOMGroupRef;
    }

    @Override
    public String getLSTformat() {
        return this.getLSTformat(true);
    }

    @Override
    public String getLSTformat(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.primitives != null) {
            arrayList.add(this.primitives.getLSTformat(bl));
        }
        if (this.pcset != null) {
            arrayList.add(this.pcset.getLSTformat(bl));
        }
        if (!this.spelltypes.isEmpty()) {
            arrayList.addAll(this.spelltypes);
        }
        return StringUtil.join(arrayList, ",");
    }

    @Override
    public Class<PCClass> getChoiceClass() {
        return PCClass.class;
    }

    @Override
    public Set<PCClass> getSet(PlayerCharacter playerCharacter) {
        HashSet<PCClass> hashSet = new HashSet<PCClass>();
        if (this.pcset != null) {
            for (PCClass pCClass : this.pcset.getSet(playerCharacter)) {
                if (pCClass.get(StringKey.SPELLTYPE) == null || playerCharacter.getClassKeyed(pCClass.getKeyName()) == null) continue;
                hashSet.add(pCClass);
            }
        }
        if (this.primitives != null) {
            hashSet.addAll(this.primitives.getSet(playerCharacter));
        }
        if (this.spelltypes != null) {
            block1: for (PCClass pCClass : this.allClasses.getContainedObjects()) {
                for (String string : this.spelltypes) {
                    if (!string.equalsIgnoreCase(pCClass.get(StringKey.SPELLTYPE)) || playerCharacter.getClassKeyed(pCClass.getKeyName()) == null) continue;
                    hashSet.add(pCClass);
                    continue block1;
                }
            }
        }
        return hashSet;
    }

    @Override
    public int hashCode() {
        return (this.pcset == null ? 0 : this.pcset.hashCode() * 29) + (this.primitives == null ? 0 : this.primitives.hashCode());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SpellCasterChoiceSet) {
            SpellCasterChoiceSet spellCasterChoiceSet = (SpellCasterChoiceSet)object;
            if (this.pcset == null ? spellCasterChoiceSet.pcset != null : !this.pcset.equals(spellCasterChoiceSet.pcset)) {
                return false;
            }
            if (this.primitives == null) {
                return spellCasterChoiceSet.primitives == null;
            }
            return this.primitives.equals(spellCasterChoiceSet.primitives);
        }
        return false;
    }
}

