/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.enumeration;

import java.util.List;
import pcgen.base.lang.UnreachableError;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SystemCollections;
import pcgen.util.enumeration.Load;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SkillArmorCheck {
    NONE{

        public int calculateBonus(PlayerCharacter playerCharacter) {
            return 0;
        }
    }
    ,
    YES,
    NONPROF{

        protected boolean useEquipment(PlayerCharacter playerCharacter, Equipment equipment) {
            return !playerCharacter.isProficientWith(equipment);
        }

        protected int calculateMin(PlayerCharacter playerCharacter) {
            return 0;
        }
    }
    ,
    DOUBLE{

        protected int getMultiplier() {
            return 2;
        }
    }
    ,
    WEIGHT{

        protected int calculateMax(PlayerCharacter playerCharacter) {
            return -((int)(playerCharacter.totalWeight().doubleValue() / 5.0));
        }
    };


    public int calculateBonus(PlayerCharacter playerCharacter) {
        int n = 0;
        int n2 = 0;
        if (Globals.checkRule("SYS_WTPSK")) {
            n = this.calculateMin(playerCharacter);
            n2 = this.calculateMax(playerCharacter);
        }
        return this.getMultiplier() * Math.min(n, n2 + (int)playerCharacter.getTotalBonusTo("MISC", "ACCHECK"));
    }

    protected int getMultiplier() {
        return 1;
    }

    protected int calculateMin(PlayerCharacter playerCharacter) {
        int n = 0;
        if (Globals.checkRule("SYS_LDPACSK")) {
            Load load = Globals.loadTypeForLoadScore(playerCharacter.getVariableValue("LOADSCORE", "").intValue(), playerCharacter.totalWeight(), playerCharacter);
            switch (load) {
                case LIGHT: {
                    n = SystemCollections.getLoadInfo().getLoadCheckPenalty("LIGHT");
                    break;
                }
                case MEDIUM: {
                    n = SystemCollections.getLoadInfo().getLoadCheckPenalty("MEDIUM");
                    break;
                }
                case HEAVY: 
                case OVERLOAD: {
                    n = SystemCollections.getLoadInfo().getLoadCheckPenalty("HEAVY");
                    break;
                }
                default: {
                    throw new UnreachableError("Internal Error: In Skill.modifier the load " + (Object)((Object)load) + " is not supported.");
                }
            }
        }
        return n;
    }

    protected int calculateMax(PlayerCharacter playerCharacter) {
        int n = 0;
        List<Equipment> list = playerCharacter.getEquipmentOfType("Armor", 1);
        for (Equipment equipment : playerCharacter.getEquipmentOfType("Shield", 1)) {
            if (list.contains(equipment)) continue;
            list.add(equipment);
        }
        for (Equipment equipment : list) {
            if (!this.useEquipment(playerCharacter, equipment)) continue;
            n += equipment.acCheck(playerCharacter).intValue();
        }
        return n;
    }

    protected boolean useEquipment(PlayerCharacter playerCharacter, Equipment equipment) {
        return true;
    }
}

