/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.helper;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.PersistentChoiceActor;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.analysis.SkillRankControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassSkillChoiceActor
implements PersistentChoiceActor<Skill> {
    private final PCClass source;
    private final Integer applyRank;

    public ClassSkillChoiceActor(PCClass pCClass, Integer n) {
        this.applyRank = n;
        this.source = pCClass;
    }

    @Override
    public void applyChoice(CDOMObject cDOMObject, Skill skill, PlayerCharacter playerCharacter) {
        Skill skill2 = playerCharacter.addSkill(skill);
        PCClass pCClass = playerCharacter.getClassKeyed(this.source.getKeyName());
        playerCharacter.addAssoc(pCClass, AssociationListKey.CSKILL, skill2);
        if (this.applyRank != null) {
            SkillRankControl.modRanks(this.applyRank.intValue(), pCClass, false, playerCharacter, skill2);
        }
    }

    @Override
    public boolean allow(Skill skill, PlayerCharacter playerCharacter, boolean bl) {
        return !playerCharacter.isClassSkill(skill);
    }

    @Override
    public Skill decodeChoice(String string) {
        return Globals.getContext().ref.silentlyGetConstructedCDOMObject(Skill.class, string);
    }

    @Override
    public String encodeChoice(Object object) {
        return ((Skill)object).getKeyName();
    }

    @Override
    public void restoreChoice(PlayerCharacter playerCharacter, CDOMObject cDOMObject, Skill skill) {
        Skill skill2 = playerCharacter.addSkill(skill);
        PCClass pCClass = playerCharacter.getClassKeyed(this.source.getKeyName());
        playerCharacter.addAssoc(pCClass, AssociationListKey.CSKILL, skill2);
    }

    public Integer getApplyRank() {
        return this.applyRank;
    }

    @Override
    public void removeChoice(PlayerCharacter playerCharacter, CDOMObject cDOMObject, Skill skill) {
        Skill skill2 = playerCharacter.addSkill(skill);
        PCClass pCClass = playerCharacter.getClassKeyed(this.source.getKeyName());
        if (this.applyRank != null) {
            SkillRankControl.modRanks(-this.applyRank.intValue(), pCClass, false, playerCharacter, skill2);
        }
        playerCharacter.removeAssoc(pCClass, AssociationListKey.CSKILL, skill2);
    }
}

