/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.modifier;

import pcgen.cdom.content.HitDie;
import pcgen.cdom.content.Modifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HitDieStep
implements Modifier<HitDie> {
    private final int numSteps;
    private final HitDie dieLimit;

    public HitDieStep(int n, HitDie hitDie) {
        if (n == 0) {
            throw new IllegalArgumentException();
        }
        this.numSteps = n;
        this.dieLimit = hitDie;
    }

    @Override
    public HitDie applyModifier(HitDie hitDie, Object object) {
        int n = this.numSteps;
        HitDie hitDie2 = hitDie;
        while (n != 0) {
            if (hitDie2.equals(this.dieLimit)) {
                return hitDie2;
            }
            if (n > 0) {
                hitDie2 = hitDie2.getNext();
                --n;
                continue;
            }
            assert (n < 0);
            hitDie2 = hitDie2.getPrevious();
            ++n;
        }
        return hitDie2;
    }

    @Override
    public String getLSTformat() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('%');
        if (this.dieLimit == null) {
            stringBuilder.append('H');
        }
        if (this.numSteps > 0) {
            stringBuilder.append("up");
        } else {
            stringBuilder.append("down");
        }
        stringBuilder.append(Math.abs(this.numSteps));
        return stringBuilder.toString();
    }

    @Override
    public Class<HitDie> getModifiedClass() {
        return HitDie.class;
    }

    public int hashCode() {
        return this.dieLimit == null ? this.numSteps : this.numSteps + this.dieLimit.hashCode() * 29;
    }

    public boolean equals(Object object) {
        if (object instanceof HitDieStep) {
            HitDieStep hitDieStep = (HitDieStep)object;
            return hitDieStep.numSteps == this.numSteps && (this.dieLimit == null && hitDieStep.dieLimit == null || this.dieLimit != null && this.dieLimit.equals(hitDieStep.dieLimit));
        }
        return false;
    }
}

