/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.reference;

import java.util.ArrayList;
import java.util.Collection;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.reference.CDOMGroupRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectMatchingReference<T extends CDOMObject, V>
extends CDOMReference<T> {
    private final CDOMGroupRef<T> all;
    private final ObjectKey<V> key;
    private final V value;
    private boolean allowNull = false;

    public ObjectMatchingReference(String string, Class<T> clazz, CDOMGroupRef<T> cDOMGroupRef, ObjectKey<V> objectKey, V v) {
        super(clazz, string);
        if (cDOMGroupRef == null) {
            throw new IllegalArgumentException("Starting Group cannot be null in ObjectMatchingReference");
        }
        if (objectKey == null) {
            throw new IllegalArgumentException("Target Key cannot be null in ObjectMatchingReference");
        }
        this.all = cDOMGroupRef;
        this.key = objectKey;
        this.value = v;
    }

    @Override
    public void addResolution(T t) {
        throw new IllegalStateException("Cannot add resolution to ObjectMatchingReference");
    }

    @Override
    public boolean contains(T t) {
        if (!this.all.contains(t)) {
            return false;
        }
        V v = ((CDOMObject)t).get(this.key);
        if (v == null) {
            return this.allowNull || this.value == null;
        }
        return this.value.equals(v);
    }

    @Override
    public Collection<T> getContainedObjects() {
        ArrayList<CDOMObject> arrayList = new ArrayList<CDOMObject>();
        for (CDOMObject cDOMObject : this.all.getContainedObjects()) {
            V v = cDOMObject.get(this.key);
            if ((v != null || this.value != null && !this.allowNull) && (this.value == null || !this.value.equals(v))) continue;
            arrayList.add(cDOMObject);
        }
        return arrayList;
    }

    @Override
    public String getLSTformat() {
        return this.getName();
    }

    @Override
    public int getObjectCount() {
        int n = 0;
        for (CDOMObject cDOMObject : this.all.getContainedObjects()) {
            V v = cDOMObject.get(this.key);
            if ((this.value != null || v != null) && (this.value == null || !this.value.equals(v))) continue;
            ++n;
        }
        return n;
    }

    public void returnIncludesNulls(boolean bl) {
        this.allowNull = bl;
    }

    public boolean equals(Object object) {
        if (object instanceof ObjectMatchingReference) {
            ObjectMatchingReference objectMatchingReference = (ObjectMatchingReference)object;
            if (this.getReferenceClass().equals(objectMatchingReference.getReferenceClass()) && this.all.equals(objectMatchingReference.all) && this.key.equals(objectMatchingReference.key)) {
                if (this.value == null) {
                    return objectMatchingReference.value == null;
                }
                return this.value.equals(objectMatchingReference.value);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getReferenceClass().hashCode() ^ this.key.hashCode() + (this.value == null ? -1 : this.value.hashCode());
    }
}

