/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.text.DecimalFormat;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.util.Logging;

public class Movement {
    private String[] movementTypes;
    private Double[] movements;
    private Double[] movementMult;
    private String[] movementMultOp;
    private int moveRatesFlag;
    private Double movement;

    public Movement() {
        this(0);
    }

    public Movement(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Argument of array length to ConcreteMovementconstructor cannot be negative");
        }
        this.movementTypes = new String[n];
        this.movements = new Double[n];
        this.movementMult = new Double[n];
        this.movementMultOp = new String[n];
    }

    public void setMoveRatesFlag(int n) {
        if (n != 0 && n != 2) {
            throw new IllegalArgumentException("Rate Flag must be 0 or 2");
        }
        this.moveRatesFlag = n;
    }

    public int getMoveRatesFlag() {
        return this.moveRatesFlag;
    }

    public Double getDoubleMovement() {
        return this.movement;
    }

    public Double getMovementMult(int n) {
        return this.movementMult[n];
    }

    public String getMovementMultOp(int n) {
        return this.movementMultOp[n];
    }

    public Double[] getMovementMult() {
        return (Double[])this.movementMult.clone();
    }

    public String[] getMovementMultOp() {
        return (String[])this.movementMultOp.clone();
    }

    public int getNumberOfMovementTypes() {
        return this.movementTypes != null ? this.movementTypes.length : 0;
    }

    public void setMovementTypes(String[] stringArray) {
        this.movementTypes = stringArray;
    }

    public String getMovementType(int n) {
        if (this.movementTypes != null && n < this.movementTypes.length) {
            return this.movementTypes[n];
        }
        return "";
    }

    public String[] getMovementTypes() {
        return (String[])this.movementTypes.clone();
    }

    public Double getMovement(int n) {
        if (this.movements != null && n < this.movements.length) {
            return this.movements[n];
        }
        return 0.0;
    }

    public int getNumberOfMovements() {
        return this.movements != null ? this.movements.length : 0;
    }

    public boolean isInitialized() {
        return this.movements != null;
    }

    public Double[] getMovements() {
        return (Double[])this.movements.clone();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.movementTypes != null && this.movementTypes.length > 0) {
            stringBuffer.append(this.movementTypes[0]);
            stringBuffer.append(' ').append(Globals.getGameModeUnitSet().convertDistanceToUnitSet(this.movements[0]));
            stringBuffer.append(Globals.getGameModeUnitSet().getDistanceUnit());
            if (this.movementMult[0] != 0.0) {
                stringBuffer.append('(').append(this.movementMultOp[0]).append(this.movementMult[0]).append(')');
            }
            for (int i = 1; i < this.movementTypes.length; ++i) {
                stringBuffer.append(", ");
                stringBuffer.append(this.movementTypes[i]);
                stringBuffer.append(' ').append(Globals.getGameModeUnitSet().convertDistanceToUnitSet(this.movements[i]));
                stringBuffer.append(Globals.getGameModeUnitSet().getDistanceUnit());
                if (this.movementMult[i] == 0.0) continue;
                stringBuffer.append('(').append(this.movementMultOp[i]).append(this.movementMult[i]).append(')');
            }
        }
        return stringBuffer.toString();
    }

    public void addTokenContents(StringBuilder stringBuilder) {
        if (this.moveRatesFlag == 2) {
            stringBuilder.append(this.movementTypes[0]);
            stringBuilder.append(',');
            stringBuilder.append(this.movementTypes[1]);
            stringBuilder.append(',');
            if (this.movementMultOp[1].length() > 0) {
                stringBuilder.append(this.movementMultOp[1]).append(this.movementMult[1].intValue());
            } else {
                stringBuilder.append(new DecimalFormat("###0").format(this.movements[1]));
            }
            return;
        }
        for (int i = 0; i < this.movementTypes.length; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            if (this.movementTypes[i] != null && this.movementTypes[i].length() > 0) {
                stringBuilder.append(this.movementTypes[i]).append(',');
            }
            if (this.movementMultOp[i].length() > 0) {
                stringBuilder.append(this.movementMultOp[i]).append(this.movementMult[i]);
                continue;
            }
            stringBuilder.append(new DecimalFormat("###0").format(this.movements[i]));
        }
    }

    public static Movement getMovementFrom(String string) {
        Movement movement;
        if (string == null) {
            throw new IllegalArgumentException("Null initialization String illegal");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() == 1) {
            movement = new Movement(1);
            movement.assignMovement(0, "Walk", stringTokenizer.nextToken());
        } else {
            movement = new Movement(stringTokenizer.countTokens() / 2);
            int n = 0;
            while (stringTokenizer.countTokens() > 1) {
                movement.assignMovement(n++, stringTokenizer.nextToken(), stringTokenizer.nextToken());
            }
            if (stringTokenizer.countTokens() != 0) {
                Logging.errorPrint("Badly formed MOVE token (extra value at end of list): " + string);
            }
        }
        return movement;
    }

    public void assignMovement(int n, String string, String string2) {
        this.movementTypes[n] = string;
        this.movementMult[n] = 0.0;
        this.movementMultOp[n] = "";
        if (string2.length() > 0 && (string2.charAt(0) == '*' || string2.charAt(0) == '/')) {
            this.movements[n] = 0.0;
            try {
                double d = Double.parseDouble(string2.substring(1));
                if (d < 0.0) {
                    Logging.errorPrint("Illegal movement multiplier: " + d + " in movement string " + string2);
                }
                this.movementMult[n] = d;
                this.movementMultOp[n] = string2.substring(0, 1);
            }
            catch (NumberFormatException numberFormatException) {
                Logging.errorPrint("Badly formed MOVE token: " + string2);
                this.movementMult[n] = 0.0;
                this.movementMultOp[n] = "";
            }
        } else if (string2.length() > 0) {
            this.movementMult[n] = 0.0;
            this.movementMultOp[n] = "";
            try {
                this.movements[n] = new Double(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Logging.errorPrint("Badly formed MOVE token: " + string2);
                this.movements[n] = 0.0;
            }
            if ("Walk".equals(this.movementTypes[n])) {
                this.movement = this.movements[n];
            }
        }
    }
}

