/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.analysis;

import pcgen.base.lang.StringUtil;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Ability;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;

public class QualifiedName {
    public static String qualifiedName(PlayerCharacter playerCharacter, Ability ability) {
        String string = ability.getOutputName();
        if ("[BASE]".equalsIgnoreCase(string)) {
            return ability.getDisplayName();
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (playerCharacter.hasAssociations(ability) && !ability.getKeyName().startsWith("Armor Proficiency")) {
            if (ability.getSafe(StringKey.CHOICE_STRING).length() == 0 || ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue() && ability.getSafe(ObjectKey.STACKS).booleanValue()) {
                if (playerCharacter.getDetailedAssociationCount(ability) > 1) {
                    stringBuffer.append(" (");
                    stringBuffer.append((int)((double)playerCharacter.getDetailedAssociationCount(ability) * ability.getSafe(ObjectKey.SELECTION_COST).doubleValue()));
                    stringBuffer.append("x)");
                }
            } else {
                stringBuffer.append(" (");
                stringBuffer.append((CharSequence)StringUtil.joinToStringBuffer(playerCharacter.getExpandedAssociations(ability), ", "));
                stringBuffer.append(')');
            }
        }
        return stringBuffer.toString();
    }

    public static String qualifiedName(PlayerCharacter playerCharacter, Skill skill) {
        if (!playerCharacter.hasAssociations(skill)) {
            return skill.getOutputName();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(skill.getOutputName()).append("(");
        stringBuilder.append((CharSequence)StringUtil.joinToStringBuffer(playerCharacter.getAssociationList(skill), ", "));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

