/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import pcgen.base.util.DoubleKeyMapToList;
import pcgen.base.util.HashMapToList;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.base.CDOMListObject;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.MasterListInterface;
import pcgen.cdom.base.PrereqObject;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.list.ClassSpellList;
import pcgen.cdom.list.DomainSpellList;
import pcgen.core.CharacterDomain;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.character.CharacterSpell;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.spell.Spell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellLevel {
    public static boolean levelForKeyContains(Spell spell, List<? extends CDOMList<Spell>> list, int n, PlayerCharacter playerCharacter) {
        if (list == null || playerCharacter == null) {
            return false;
        }
        TreeSet treeSet = new TreeSet();
        HashMapToList<CDOMList<Spell>, Integer> hashMapToList = playerCharacter.getMasterLevelInfo(spell);
        HashMapToList<CDOMList<Spell>, Integer> hashMapToList2 = playerCharacter.getPCBasedLevelInfo(spell);
        for (CDOMList<Spell> cDOMList : list) {
            List list2 = hashMapToList.getListFor(cDOMList);
            if (list2 != null) {
                treeSet.addAll(list2);
            }
            if (!treeSet.isEmpty() || (list2 = hashMapToList2.getListFor(cDOMList)) == null) continue;
            treeSet.addAll(list2);
        }
        return n == -1 && !treeSet.isEmpty() || n >= 0 && treeSet.contains(n);
    }

    public static Integer[] levelForKey(Spell spell, List<? extends CDOMList<Spell>> list, PlayerCharacter playerCharacter) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (list != null) {
            for (CDOMList<Spell> cDOMList : list) {
                arrayList.add(SpellLevel.getFirstLvlForKey(spell, cDOMList, playerCharacter));
            }
        }
        return arrayList.toArray(new Integer[arrayList.size()]);
    }

    public static int getFirstLvlForKey(Spell spell, CDOMList<Spell> cDOMList, PlayerCharacter playerCharacter) {
        List list;
        HashMapToList<CDOMList<Spell>, Integer> hashMapToList = playerCharacter.getLevelInfo(spell);
        if (hashMapToList != null && hashMapToList.size() != 0 && (list = hashMapToList.getListFor(cDOMList)) != null) {
            return (Integer)list.get(0);
        }
        return -1;
    }

    public static boolean isLevel(Spell spell, int n, PlayerCharacter playerCharacter) {
        Collection<AssociatedPrereqObject> collection;
        CDOMListObject cDOMListObject;
        Integer n2 = n;
        MasterListInterface masterListInterface = Globals.getMasterLists();
        for (PCClass object : playerCharacter.getClassList()) {
            cDOMListObject = object.get(ObjectKey.CLASS_SPELLLIST);
            collection = masterListInterface.getAssociations(cDOMListObject, spell);
            if (collection == null) continue;
            for (AssociatedPrereqObject associatedPrereqObject : collection) {
                if (!PrereqHandler.passesAll(associatedPrereqObject.getPrerequisiteList(), playerCharacter, spell) || !n2.equals(associatedPrereqObject.getAssociation(AssociationKey.SPELL_LEVEL))) continue;
                return true;
            }
        }
        for (CharacterDomain characterDomain : playerCharacter.getCharacterDomainList()) {
            cDOMListObject = characterDomain.getDomain().get(ObjectKey.DOMAIN_SPELLLIST);
            collection = masterListInterface.getAssociations(cDOMListObject, spell);
            if (collection == null) continue;
            for (AssociatedPrereqObject associatedPrereqObject : collection) {
                if (!PrereqHandler.passesAll(associatedPrereqObject.getPrerequisiteList(), playerCharacter, spell) || !n2.equals(associatedPrereqObject.getAssociation(AssociationKey.SPELL_LEVEL))) continue;
                return true;
            }
        }
        return false;
    }

    public static int getFirstLevelForKey(Spell spell, List<? extends CDOMList<Spell>> list, PlayerCharacter playerCharacter) {
        Integer[] integerArray = SpellLevel.levelForKey(spell, list, playerCharacter);
        int n = -1;
        if (integerArray.length > 0) {
            for (int i = 0; i < integerArray.length; ++i) {
                if (integerArray[i] <= -1) continue;
                return integerArray[i];
            }
        }
        return n;
    }

    public static HashMapToList<CDOMList<Spell>, Integer> getMasterLevelInfo(PlayerCharacter playerCharacter, Spell spell) {
        HashMapToList<CDOMList<Spell>, Integer> hashMapToList = new HashMapToList<CDOMList<Spell>, Integer>();
        MasterListInterface masterListInterface = Globals.getMasterLists();
        for (CDOMReference cDOMReference : masterListInterface.getActiveLists()) {
            for (CDOMList cDOMList : cDOMReference.getContainedObjects()) {
                if (!(cDOMList instanceof ClassSpellList) && !(cDOMList instanceof DomainSpellList)) continue;
                Collection<AssociatedPrereqObject> collection = masterListInterface.getAssociations(cDOMList, spell);
                for (AssociatedPrereqObject associatedPrereqObject : collection) {
                    if (!PrereqHandler.passesAll(associatedPrereqObject.getPrerequisiteList(), playerCharacter, null)) continue;
                    Integer n = associatedPrereqObject.getAssociation(AssociationKey.SPELL_LEVEL);
                    hashMapToList.addToListFor(cDOMList, n);
                }
            }
        }
        return hashMapToList;
    }

    public static HashMapToList<CDOMList<Spell>, Integer> getPCBasedLevelInfo(PlayerCharacter playerCharacter, Spell spell) {
        HashMapToList<CDOMList<Spell>, Integer> hashMapToList = new HashMapToList<CDOMList<Spell>, Integer>();
        for (CDOMObject cDOMObject : playerCharacter.getCDOMObjectList()) {
            Collection<CDOMReference<? extends CDOMList<? extends PrereqObject>>> collection = cDOMObject.getModifiedLists();
            for (CDOMReference<? extends CDOMList<? extends PrereqObject>> cDOMReference : collection) {
                Collection<? extends CDOMList<? extends PrereqObject>> collection2 = cDOMReference.getContainedObjects();
                for (CDOMList<? extends PrereqObject> cDOMList : collection2) {
                    if (!(cDOMList instanceof ClassSpellList) && !(cDOMList instanceof DomainSpellList)) continue;
                    CDOMReference<? extends CDOMList<? extends PrereqObject>> cDOMReference2 = cDOMReference;
                    Collection collection3 = cDOMObject.getListMods(cDOMReference2);
                    for (CDOMReference cDOMReference3 : collection3) {
                        if (!cDOMReference3.contains(spell)) continue;
                        Collection<AssociatedPrereqObject> collection4 = cDOMObject.getListAssociations(cDOMReference2, cDOMReference3);
                        for (AssociatedPrereqObject associatedPrereqObject : collection4) {
                            if (!PrereqHandler.passesAll(associatedPrereqObject.getPrerequisiteList(), playerCharacter, null)) continue;
                            Integer n = associatedPrereqObject.getAssociation(AssociationKey.SPELL_LEVEL);
                            hashMapToList.addToListFor(cDOMList, n);
                        }
                    }
                }
            }
        }
        return hashMapToList;
    }

    public static DoubleKeyMapToList<Spell, CDOMList<Spell>, Integer> getPCBasedLevelInfo(PlayerCharacter playerCharacter) {
        DoubleKeyMapToList<Spell, CDOMList<Spell>, Integer> doubleKeyMapToList = new DoubleKeyMapToList<Spell, CDOMList<Spell>, Integer>();
        for (CDOMObject cDOMObject : playerCharacter.getCDOMObjectList()) {
            Collection<CDOMReference<? extends CDOMList<? extends PrereqObject>>> collection = cDOMObject.getModifiedLists();
            for (CDOMReference<? extends CDOMList<? extends PrereqObject>> cDOMReference : collection) {
                Collection<? extends CDOMList<? extends PrereqObject>> collection2 = cDOMReference.getContainedObjects();
                for (CDOMList<? extends PrereqObject> cDOMList : collection2) {
                    if (!(cDOMList instanceof ClassSpellList) && !(cDOMList instanceof DomainSpellList)) continue;
                    CDOMReference<? extends CDOMList<? extends PrereqObject>> cDOMReference2 = cDOMReference;
                    Collection collection3 = cDOMObject.getListMods(cDOMReference2);
                    for (CDOMReference cDOMReference3 : collection3) {
                        Collection<AssociatedPrereqObject> collection4 = cDOMObject.getListAssociations(cDOMReference2, cDOMReference3);
                        for (AssociatedPrereqObject associatedPrereqObject : collection4) {
                            if (!PrereqHandler.passesAll(associatedPrereqObject.getPrerequisiteList(), playerCharacter, null)) continue;
                            Integer n = associatedPrereqObject.getAssociation(AssociationKey.SPELL_LEVEL);
                            for (Spell spell : cDOMReference3.getContainedObjects()) {
                                doubleKeyMapToList.addToListFor(spell, cDOMList, n);
                            }
                        }
                    }
                }
            }
        }
        return doubleKeyMapToList;
    }

    public static Map<Integer, List<Spell>> getPCBasedBonusKnownSpells(PlayerCharacter playerCharacter, PCClass pCClass) {
        HashMap<Integer, List<Spell>> hashMap = new HashMap<Integer, List<Spell>>();
        ClassSpellList classSpellList = pCClass.get(ObjectKey.CLASS_SPELLLIST);
        for (CDOMObject cDOMObject : playerCharacter.getCDOMObjectList()) {
            Collection<CDOMReference<? extends CDOMList<? extends PrereqObject>>> collection = cDOMObject.getModifiedLists();
            for (CDOMReference<? extends CDOMList<? extends PrereqObject>> cDOMReference : collection) {
                Collection<? extends CDOMList<? extends PrereqObject>> collection2 = cDOMReference.getContainedObjects();
                for (CDOMList<? extends PrereqObject> cDOMList : collection2) {
                    if (cDOMList != classSpellList) continue;
                    CDOMReference<? extends CDOMList<? extends PrereqObject>> cDOMReference2 = cDOMReference;
                    Collection collection3 = cDOMObject.getListMods(cDOMReference2);
                    for (CDOMReference cDOMReference3 : collection3) {
                        Collection<AssociatedPrereqObject> collection4 = cDOMObject.getListAssociations(cDOMReference2, cDOMReference3);
                        for (AssociatedPrereqObject associatedPrereqObject : collection4) {
                            if (!PrereqHandler.passesAll(associatedPrereqObject.getPrerequisiteList(), playerCharacter, null)) continue;
                            Integer n = associatedPrereqObject.getAssociation(AssociationKey.SPELL_LEVEL);
                            Boolean bl = associatedPrereqObject.getAssociation(AssociationKey.KNOWN);
                            if (bl == null || !bl.booleanValue()) continue;
                            Collection collection5 = cDOMReference3.getContainedObjects();
                            List<Spell> list = hashMap.get(n);
                            if (list == null) {
                                list = new ArrayList<Spell>();
                                hashMap.put(n, list);
                            }
                            list.addAll(collection5);
                        }
                    }
                }
            }
        }
        return hashMap;
    }

    public static void addBonusKnowSpellsToList(PlayerCharacter playerCharacter, PObject pObject, Collection<CharacterSpell> collection) {
        if (!(pObject instanceof PCClass)) {
            return;
        }
        Map<Integer, List<Spell>> map = SpellLevel.getPCBasedBonusKnownSpells(playerCharacter, (PCClass)pObject);
        for (Integer n : map.keySet()) {
            List<Spell> list = map.get(n);
            for (Spell spell : list) {
                CharacterSpell characterSpell = new CharacterSpell(pObject, spell);
                characterSpell.addInfo(n, 1, Globals.getDefaultSpellBook());
                collection.add(characterSpell);
            }
        }
    }

    public static int getNumBonusKnowSpellsForLevel(PlayerCharacter playerCharacter, PObject pObject, int n) {
        if (!(pObject instanceof PCClass)) {
            return 0;
        }
        Map<Integer, List<Spell>> map = SpellLevel.getPCBasedBonusKnownSpells(playerCharacter, (PCClass)pObject);
        List<Spell> list = map.get(n);
        return list != null ? list.size() : 0;
    }
}

