/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.character;

import pcgen.base.formula.Formula;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.core.Equipment;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;

public class SpellBook
implements Cloneable {
    public static final int TYPE_KNOWN_SPELLS = 1;
    public static final int TYPE_PREPARED_LIST = 2;
    public static final int TYPE_SPELL_BOOK = 3;
    public static final int TYPE_INNATE_SPELLS = 4;
    private String name;
    private int type;
    private int numPages;
    private int numPagesUsed;
    private int numSpells;
    private Formula pageFormula;
    private String description;
    private Equipment equip;

    public SpellBook(String string, int n) {
        this.name = string;
        this.type = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.name);
        if (this.type == 3) {
            stringBuffer.append(" [");
            stringBuffer.append(this.numPagesUsed);
            stringBuffer.append('/');
            stringBuffer.append(this.numPages);
            stringBuffer.append(']');
        }
        return stringBuffer.toString();
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String string) {
        this.description = string;
    }

    public final Equipment getEquip() {
        return this.equip;
    }

    public final void setEquip(Equipment equipment) {
        this.equip = equipment;
        this.setNumPages(equipment.getSafe(IntegerKey.NUM_PAGES));
        this.setPageFormula(equipment.getSafe(FormulaKey.PAGE_USAGE));
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String string) {
        this.name = string;
    }

    public final int getNumPages() {
        return this.numPages;
    }

    public final void setNumPages(int n) {
        this.numPages = n;
    }

    public final Formula getPageFormula() {
        return this.pageFormula;
    }

    public final void setPageFormula(Formula formula) {
        this.pageFormula = formula;
    }

    public final int getType() {
        return this.type;
    }

    public final void setType(int n) {
        this.type = n;
    }

    public final String getTypeName() {
        String string = "";
        switch (this.getType()) {
            case 1: {
                string = "Known Spell List";
                break;
            }
            case 2: {
                string = "Prepared Spell List";
                break;
            }
            case 3: {
                string = "Spell Book";
                break;
            }
            case 4: {
                string = "Innate Spell List";
                break;
            }
            default: {
                string = "Unknown spell list type: " + this.getType();
            }
        }
        return string;
    }

    public final int getNumPagesUsed() {
        return this.numPagesUsed;
    }

    public final void setNumPagesUsed(int n) {
        this.numPagesUsed = n;
    }

    public final int getNumSpells() {
        return this.numSpells;
    }

    public final void setNumSpells(int n) {
        this.numSpells = n;
    }

    public Object clone() {
        SpellBook spellBook = null;
        try {
            spellBook = (SpellBook)super.clone();
            if (this.equip != null) {
                spellBook.equip = this.equip.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ShowMessageDelegate.showMessageDialog("Clone of SpellBook failed due to " + cloneNotSupportedException.getMessage(), "PCGen", MessageType.ERROR);
        }
        return spellBook;
    }
}

