/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.chooser;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.base.formula.Formula;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.chooser.ChoiceManagerList;
import pcgen.util.Logging;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBasicChoiceManager<T>
implements ChoiceManagerList<T> {
    private int numberOfChoices;
    private final int choicesPerUnitCost;
    private final String chooserHandled;
    private final ArrayList<String> choices = new ArrayList();
    protected final PObject pobject;
    private ChooseController<T> controller = new ChooseController();
    private int preChooserChoices;
    private String title = null;

    public AbstractBasicChoiceManager(PObject pObject, String string, PlayerCharacter playerCharacter) {
        Object object;
        this.pobject = pObject;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string2 = stringTokenizer.nextToken();
        Formula formula = this.pobject.getSafe(FormulaKey.SELECT);
        int n = -1;
        while (stringTokenizer.hasMoreTokens() && string2.startsWith("TITLE=")) {
            object = string2.substring(6);
            if (((String)object).startsWith("\"")) {
                object = ((String)object).substring(1, ((String)object).length() - 1);
            }
            this.setTitle((String)object);
            string2 = stringTokenizer.nextToken();
        }
        object = this.pobject.get(FormulaKey.NUMCHOICES);
        if (object != null && (n = object.resolve(playerCharacter, "").intValue()) <= 0) {
            Logging.errorPrint("Found CHOOSER with choices <= 0: " + string + " where total choices " + "from NUMCHOICES resolves to: " + n);
            n = 0;
        }
        while (stringTokenizer.hasMoreTokens()) {
            this.choices.add(stringTokenizer.nextToken());
        }
        this.choices.trimToSize();
        this.chooserHandled = string2;
        this.numberOfChoices = n;
        this.choicesPerUnitCost = formula.resolve(playerCharacter, "").intValue();
    }

    @Override
    public abstract void getChoices(PlayerCharacter var1, List<T> var2, List<T> var3);

    @Override
    public List<T> doChooser(PlayerCharacter playerCharacter, List<T> list, List<T> list2, List<String> list3) {
        int n = (list2.size() + (this.choicesPerUnitCost - 1)) / this.choicesPerUnitCost;
        int n2 = (list3.size() + (this.choicesPerUnitCost - 1)) / this.choicesPerUnitCost;
        int n3 = this.numberOfChoices - n2 + n;
        int n4 = this.numberOfChoices == -1 ? this.controller.getTotalChoices() : n3;
        int n5 = Math.min(this.controller.getPool() + n, n4 / this.choicesPerUnitCost);
        ChooserInterface chooserInterface = this.getChooserInstance();
        boolean bl = this.controller.isMultYes() && this.controller.isStackYes();
        chooserInterface.setAllowsDups(bl);
        if (!bl) {
            list.removeAll(list3);
        }
        Globals.sortChooserLists(list, list2);
        chooserInterface.setAvailableList(list);
        chooserInterface.setSelectedList(list2);
        chooserInterface.setChoicesPerUnit(this.choicesPerUnitCost);
        chooserInterface.setTotalChoicesAvail(n5);
        chooserInterface.setPoolFlag(false);
        this.processUniqueItems(chooserInterface);
        chooserInterface.setVisible(true);
        return chooserInterface.getSelectedList();
    }

    protected ChooserInterface getChooserInstance() {
        ChooserInterface chooserInterface = ChooserFactory.getChooserInstance();
        if (this.title != null && this.title.length() > 0) {
            chooserInterface.setTitle(this.title + " (" + this.pobject.getDisplayName() + ')');
        }
        return chooserInterface;
    }

    protected void processUniqueItems(ChooserInterface chooserInterface) {
    }

    @Override
    public void doChooserRemove(PlayerCharacter playerCharacter, List<T> list, List<T> list2, List<String> list3) {
        List<T> list4 = this.doChooser(playerCharacter, list, list2, list3);
        this.applyChoices(playerCharacter, list4);
    }

    @Override
    public abstract void applyChoices(PlayerCharacter var1, List<T> var2);

    public List<String> getChoiceList() {
        return this.choices;
    }

    @Override
    public String typeHandled() {
        return this.chooserHandled;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    protected void setPreChooserChoices(int n) {
        this.preChooserChoices = n;
    }

    protected void adjustPool(List<T> list) {
        this.controller.adjustPool(list);
    }

    public boolean isMultYes() {
        return this.controller.isMultYes();
    }

    public boolean isStackYes() {
        return this.controller.isStackYes();
    }

    public void setController(ChooseController<T> chooseController) {
        this.controller = chooseController;
    }

    protected void setMaxChoices(int n) {
        this.numberOfChoices = n;
    }

    public int getNumberOfChoices() {
        return this.numberOfChoices;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AbilityChooseController
    extends ChooseController<Ability> {
        private final Ability ability;
        private final AbilityCategory ac;
        private final PlayerCharacter pc;

        public AbilityChooseController(Ability ability, AbilityCategory abilityCategory, PlayerCharacter playerCharacter) {
            if (ability == null) {
                throw new IllegalArgumentException("Ability cannot be null for AbilityChooseController");
            }
            this.ability = ability;
            this.ac = abilityCategory;
            this.pc = playerCharacter;
        }

        @Override
        public int getPool() {
            return this.isMultYes() ? this.pc.getAvailableAbilityPool(this.ac).intValue() : 1;
        }

        @Override
        public boolean isMultYes() {
            return this.ability.getSafe(ObjectKey.MULTIPLE_ALLOWED);
        }

        @Override
        public boolean isStackYes() {
            return this.ability.getSafe(ObjectKey.STACKS);
        }

        @Override
        public double getCost() {
            return this.ability.getSafe(ObjectKey.SELECTION_COST).doubleValue();
        }

        @Override
        public int getTotalChoices() {
            return this.isMultYes() ? Integer.MAX_VALUE : 1;
        }

        @Override
        public void adjustPool(List<Ability> list) {
            double d;
            if (AbilityCategory.FEAT.equals(this.ac) && (d = this.getCost()) > 0.0) {
                int n = (AbstractBasicChoiceManager.this.preChooserChoices + (AbstractBasicChoiceManager.this.choicesPerUnitCost - 1)) / AbstractBasicChoiceManager.this.choicesPerUnitCost;
                int n2 = (list.size() + (AbstractBasicChoiceManager.this.choicesPerUnitCost - 1)) / AbstractBasicChoiceManager.this.choicesPerUnitCost;
                this.pc.adjustFeats(d * (double)(n - n2));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ChooseController<T> {
        public int getPool() {
            return 1;
        }

        public boolean isMultYes() {
            return false;
        }

        public boolean isStackYes() {
            return false;
        }

        public double getCost() {
            return 1.0;
        }

        public int getTotalChoices() {
            return 1;
        }

        public void adjustPool(List<T> list) {
        }
    }
}

