/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.chooser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Ability;
import pcgen.core.Categorisable;
import pcgen.core.CategorisableStore;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.WeaponProf;
import pcgen.core.character.WieldCategory;
import pcgen.core.chooser.AbstractBasicChoiceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleWeaponProfChoiceManager
extends AbstractBasicChoiceManager<String> {
    final CategorisableStore weaponToProfMap = new CategorisableStore();

    public SimpleWeaponProfChoiceManager(PObject pObject, String string, PlayerCharacter playerCharacter) {
        super(pObject, string, playerCharacter);
        this.setTitle("Weapon Choice(s)");
    }

    @Override
    public void getChoices(PlayerCharacter playerCharacter, List<String> list, List<String> list2) {
        this.weaponToProfMap.clear();
        list2.addAll(this.pobject.getSafeListFor(ListKey.SELECTED_WEAPON_PROF_BONUS));
        List<String> list3 = this.getChoiceList();
        List<String> list4 = list3.subList(1, list3.size());
        Iterator<String> iterator = list4.iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = string = iterator.next();
            String string3 = string;
            if (string.lastIndexOf(91) >= 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "[]");
                String string4 = stringTokenizer.nextToken();
                while (stringTokenizer.hasMoreTokens()) {
                    this.weaponToProfMap.addCategorisable(new weaponToProf(string4, stringTokenizer.nextToken()));
                }
                string2 = string4;
            }
            if ("DEITYWEAPON".equals(string2)) {
                this.buildWeaponProfDeityChoices(string3, list, playerCharacter);
                continue;
            }
            if (string2.startsWith("TYPE=") || string2.startsWith("TYPE.")) {
                this.buildWeaponProfTypeChoices(string3, list, string2, playerCharacter);
                continue;
            }
            if (string2.startsWith("WIELD=") || string2.startsWith("WIELD.")) {
                this.buildWeaponProfWeildChoices(string3, list, string2, playerCharacter);
                continue;
            }
            if (string2.startsWith("!TYPE=") || string2.startsWith("!TYPE.")) {
                this.removeExcludedWeaponProfTypeChoices(string2, list, playerCharacter);
                continue;
            }
            list.add(string2);
        }
        this.setPreChooserChoices(list2.size());
    }

    private void buildWeaponProfDeityChoices(String string, List<String> list, PlayerCharacter playerCharacter) {
        if (playerCharacter.getDeity() != null) {
            List<CDOMReference<WeaponProf>> list2 = playerCharacter.getDeity().getSafeListFor(ListKey.DEITYWEAPON);
            for (CDOMReference<WeaponProf> cDOMReference : list2) {
                for (WeaponProf weaponProf : cDOMReference.getContainedObjects()) {
                    this.addtoToAvailableAndMap(string, list, weaponProf);
                }
            }
        }
    }

    private void buildWeaponProfTypeChoices(String string, List<String> list, String string2, PlayerCharacter playerCharacter) {
        String string3 = string2.substring(5);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ".");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = -1;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.startsWith("SIZE=") || string2.startsWith("SIZE.")) {
                n = Globals.sizeInt(string4.substring(5));
                continue;
            }
            arrayList.add(string4);
        }
        for (Equipment equipment : Globals.getContext().ref.getConstructedCDOMObjects(Equipment.class)) {
            String string5;
            if (!equipment.isWeapon()) continue;
            boolean bl = true;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext() && equipment.isType(string5 = (String)iterator.next())) {
                CDOMSingleRef<WeaponProf> cDOMSingleRef;
                if (n >= 0) {
                    bl &= Globals.sizeInt(equipment.getSize()) == n;
                }
                if (!bl || (cDOMSingleRef = equipment.get(ObjectKey.WEAPON_PROF)) == null) continue;
                this.addtoToAvailableAndMap(string, list, cDOMSingleRef.resolvesTo());
            }
        }
    }

    private void buildWeaponProfWeildChoices(String string, List<String> list, String string2, PlayerCharacter playerCharacter) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2.substring(6), ".");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        block1: for (Equipment equipment : Globals.getContext().ref.getConstructedCDOMObjects(Equipment.class)) {
            if (!equipment.isWeapon()) continue;
            for (String string3 : arrayList) {
                WieldCategory wieldCategory = equipment.get(ObjectKey.WIELD);
                if (wieldCategory == null || !wieldCategory.getName().equalsIgnoreCase(string3)) continue block1;
                CDOMSingleRef<WeaponProf> cDOMSingleRef = equipment.get(ObjectKey.WEAPON_PROF);
                if (cDOMSingleRef == null) continue;
                this.addtoToAvailableAndMap(string, list, cDOMSingleRef.resolvesTo());
            }
        }
    }

    private void addtoToAvailableAndMap(String string, List<String> list, WeaponProf weaponProf) {
        String string2 = weaponProf.getKeyName();
        if (!list.contains(string2)) {
            list.add(string2);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "[]");
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
                while (stringTokenizer.hasMoreTokens()) {
                    this.weaponToProfMap.addCategorisable(new weaponToProf(string2, stringTokenizer.nextToken()));
                }
            }
        }
    }

    private void removeExcludedWeaponProfTypeChoices(String string, List<String> list, PlayerCharacter playerCharacter) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(6), ".");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        for (Equipment equipment : Globals.getContext().ref.getConstructedCDOMObjects(Equipment.class)) {
            String string2;
            if (!equipment.isWeapon()) continue;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext() && equipment.isType(string2 = (String)iterator.next())) {
                String string3;
                CDOMSingleRef<WeaponProf> cDOMSingleRef = equipment.get(ObjectKey.WEAPON_PROF);
                if (cDOMSingleRef == null || !list.contains(string3 = cDOMSingleRef.resolvesTo().getKeyName())) continue;
                list.remove(string3);
            }
        }
    }

    @Override
    public void applyChoices(PlayerCharacter playerCharacter, List<String> list) {
        this.pobject.clearSelectedWeaponProfBonus();
        playerCharacter.setAutomaticAbilitiesStable(null, false);
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext() && !this.weaponToProfMap.isEmpty()) {
            String string = iterator.next();
            Iterator<Categorisable> iterator2 = this.weaponToProfMap.getKeyIterator(string);
            while (iterator2.hasNext()) {
                Ability ability;
                String string2;
                String string3 = iterator2.next().toString();
                if (string3 == null) continue;
                if (string3.startsWith("WEAPONPROF")) {
                    this.pobject.addSelectedWeaponProfBonus(string);
                    continue;
                }
                if (!string3.startsWith("FEAT=") && !string3.startsWith("FEAT.")) continue;
                if (this.pobject instanceof Domain) {
                    playerCharacter.removeAllAssociations(this.pobject);
                    string2 = string3.substring(5);
                    ability = Globals.getAbilityKeyed("FEAT", string2);
                    if (ability == null) continue;
                    playerCharacter.addAssociation((CDOMObject)this.pobject, "FEAT?" + ability.getKeyName() + "(" + string + ")");
                    continue;
                }
                string2 = string3.substring(5);
                ability = playerCharacter.getFeatNamed(string2);
                if (ability == null) {
                    ability = Globals.getAbilityKeyed("FEAT", string2);
                    if ((ability = ability.clone()) != null) {
                        playerCharacter.addFeat(ability, null);
                    }
                }
                if (ability == null || playerCharacter.containsAssociated((CDOMObject)ability, string)) continue;
                playerCharacter.addAssociation((CDOMObject)ability, string);
            }
        }
        playerCharacter.setAggregateAbilitiesStable(null, false);
    }

    public Collection<WeaponProf> getAllObjects() {
        return Globals.getContext().ref.getConstructedCDOMObjects(WeaponProf.class);
    }

    public class weaponToProf
    implements Categorisable {
        String category;
        String keyName;

        public weaponToProf(String string, String string2) {
            this.category = string;
            this.keyName = string2;
        }

        public String getCategory() {
            return this.category;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public String getDisplayName() {
            return this.keyName;
        }

        public String toString() {
            return this.keyName;
        }
    }
}

