/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.chooser;

import java.util.Collection;
import java.util.List;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.analysis.SkillRankControl;
import pcgen.core.chooser.AbstractEasyStringChoiceManager;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkillsNamedChoiceManager
extends AbstractEasyStringChoiceManager<Skill> {
    public SkillsNamedChoiceManager(PObject pObject, String string, PlayerCharacter playerCharacter) {
        super(pObject, string, playerCharacter);
        this.setTitle("Skills Choice");
    }

    @Override
    public Collection<Skill> getAllObjects() {
        return Globals.getObjectsOfVisibility(Globals.getContext().ref.getConstructedCDOMObjects(Skill.class), Visibility.DISPLAY_ONLY);
    }

    @Override
    public Skill getSpecificObject(String string) {
        return Globals.getContext().ref.silentlyGetConstructedCDOMObject(Skill.class, string);
    }

    @Override
    protected void processOther(String string, List<String> list, PlayerCharacter playerCharacter) {
        if ("CLASS".equals(string)) {
            for (Skill skill : this.getAllObjects()) {
                if (!playerCharacter.isClassSkill(skill)) continue;
                list.add(skill.getKeyName());
            }
        } else if ("CROSSCLASS".equals(string)) {
            for (Skill skill : this.getAllObjects()) {
                if (!playerCharacter.isCrossClassSkill(skill)) continue;
                list.add(skill.getKeyName());
            }
        } else if ("EXCLUSIVE".equals(string)) {
            for (Skill skill : this.getAllObjects()) {
                if (playerCharacter.isClassSkill(skill) || playerCharacter.isCrossClassSkill(skill)) continue;
                list.add(skill.getKeyName());
            }
        } else if ("NORANK".equals(string)) {
            for (Skill skill : this.getAllObjects()) {
                Skill skill2 = playerCharacter.getSkillKeyed(skill.getKeyName());
                if (skill2 != null && Double.compare(SkillRankControl.getRank(playerCharacter, skill2).doubleValue(), 0.0) != 0) continue;
                list.add(skill.getKeyName());
            }
        } else if (string.startsWith("RANKS=")) {
            Double d = new Double(string.substring(6));
            for (Skill skill : this.getAllObjects()) {
                Skill skill3 = playerCharacter.getSkillKeyed(skill.getKeyName());
                if (skill3 == null || Double.compare(SkillRankControl.getRank(playerCharacter, skill3).doubleValue(), d) < 0) continue;
                list.add(skill.getKeyName());
            }
        } else if (string.endsWith("%")) {
            string = string.substring(0, string.length() - 1);
            for (Skill skill : this.getAllObjects()) {
                if (!skill.getKeyName().startsWith(string)) continue;
                list.add(skill.getKeyName());
            }
        } else {
            super.processOther(string, list, playerCharacter);
        }
    }
}

