/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import pcgen.base.formula.Formula;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.CharacterDomain;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PlayerCharacter;
import pcgen.core.analysis.DomainApplication;
import pcgen.core.kit.BaseKit;
import pcgen.core.prereq.PrereqHandler;
import pcgen.gui.CharacterInfo;
import pcgen.gui.PCGen_Frame1;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KitDeity
extends BaseKit {
    private CDOMSingleRef<Deity> theDeityRef;
    private Formula choiceCount;
    private List<CDOMSingleRef<Domain>> theDomains = null;
    private transient Deity theDeity = null;
    private transient List<Domain> domainsToAdd = null;

    public void addDomain(CDOMSingleRef<Domain> cDOMSingleRef) {
        if (this.theDomains == null) {
            this.theDomains = new ArrayList<CDOMSingleRef<Domain>>(3);
        }
        this.theDomains.add(cDOMSingleRef);
    }

    public List<CDOMSingleRef<Domain>> getDomains() {
        if (this.theDomains == null) {
            return null;
        }
        return Collections.unmodifiableList(this.theDomains);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.theDeityRef.getLSTformat());
        if (this.theDomains != null && this.theDomains.size() > 0) {
            stringBuffer.append(" (");
            if (this.choiceCount != null) {
                stringBuffer.append(this.choiceCount.toString());
                stringBuffer.append(" of ");
            }
            Iterator<CDOMSingleRef<Domain>> iterator = this.theDomains.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean testApply(Kit kit, PlayerCharacter playerCharacter, List<String> list) {
        List<CDOMSingleRef<Domain>> list2;
        this.domainsToAdd = null;
        this.theDeity = this.theDeityRef.resolvesTo();
        if (!playerCharacter.canSelectDeity(this.theDeity)) {
            list.add("DEITY: Cannot select deity \"" + this.theDeity.getDisplayName() + "\"");
            return false;
        }
        playerCharacter.setDeity(this.theDeity);
        if (this.theDomains == null || this.theDomains.size() == 0) {
            return true;
        }
        if (playerCharacter.getMaxCharacterDomains() <= 0) {
            list.add("DEITY: Not allowed to choose a domain");
            return true;
        }
        int n = this.choiceCount == null ? this.theDomains.size() : this.choiceCount.resolve(playerCharacter, "").intValue();
        if (n > this.theDomains.size()) {
            n = this.theDomains.size();
        }
        if (n == 0) {
            return true;
        }
        if (n == this.theDomains.size()) {
            list2 = this.theDomains;
        } else {
            while ((list2 = Globals.getChoiceFromList("Choose Domains", this.theDomains, new ArrayList(), n)).size() == 0) {
            }
        }
        for (CDOMSingleRef<Domain> cDOMSingleRef : list2) {
            Domain domain = cDOMSingleRef.resolvesTo();
            if (!PrereqHandler.passesAll(domain.getPrerequisiteList(), playerCharacter, domain)) {
                list.add("DEITY: Not qualified for domain \"" + domain.getDisplayName() + "\"");
                continue;
            }
            CharacterDomain characterDomain = playerCharacter.getCharacterDomainForDomain(domain.getKeyName());
            if (characterDomain == null) {
                characterDomain = playerCharacter.getNewCharacterDomain();
            }
            if (characterDomain == null || playerCharacter.getCharacterDomainUsed() >= playerCharacter.getMaxCharacterDomains()) {
                list.add("DEITY: No more allowed domains");
                return false;
            }
            if (this.domainsToAdd == null) {
                this.domainsToAdd = new ArrayList<Domain>();
            }
            this.domainsToAdd.add(domain);
            Domain domain2 = characterDomain.setDomain(domain, playerCharacter);
            playerCharacter.addCharacterDomain(characterDomain);
            DomainApplication.applyDomain(playerCharacter, domain2);
        }
        playerCharacter.calcActiveBonuses();
        return true;
    }

    @Override
    public void apply(PlayerCharacter playerCharacter) {
        if (this.theDeity == null) {
            return;
        }
        playerCharacter.setDeity(this.theDeity);
        if (this.domainsToAdd == null) {
            return;
        }
        for (Domain domain : this.domainsToAdd) {
            CharacterDomain characterDomain = playerCharacter.getCharacterDomainForDomain(domain.getKeyName());
            if (characterDomain == null) {
                characterDomain = playerCharacter.getNewCharacterDomain();
            }
            if (characterDomain == null) continue;
            Domain domain2 = characterDomain.setDomain(domain, playerCharacter);
            playerCharacter.addCharacterDomain(characterDomain);
            DomainApplication.applyDomain(playerCharacter, domain2);
        }
        playerCharacter.calcActiveBonuses();
        CharacterInfo characterInfo = PCGen_Frame1.getCharacterPane();
        characterInfo.setPaneForUpdate(characterInfo.infoDomain());
        characterInfo.refresh();
        this.theDeity = null;
        this.domainsToAdd = null;
    }

    @Override
    public String getObjectName() {
        return "Deity";
    }

    public void setCount(Formula formula) {
        this.choiceCount = formula;
    }

    public Formula getCount() {
        return this.choiceCount;
    }

    public void setDeity(CDOMSingleRef<Deity> cDOMSingleRef) {
        this.theDeityRef = cDOMSingleRef;
    }

    public CDOMSingleRef<Deity> getDeityRef() {
        return this.theDeityRef;
    }
}

