/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.util.ArrayList;
import java.util.List;
import pcgen.cdom.base.PersistentTransitionChoice;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Kit;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.kit.BaseKit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KitLevelAbility
extends BaseKit {
    private CDOMSingleRef<PCClass> theClassName;
    private int theLevel;
    private List<String> choiceList = new ArrayList<String>();
    private PersistentTransitionChoice<?> add;

    public void setClass(CDOMSingleRef<PCClass> cDOMSingleRef) {
        this.theClassName = cDOMSingleRef;
    }

    public CDOMSingleRef<PCClass> getPCClass() {
        return this.theClassName;
    }

    public void setLevel(int n) {
        this.theLevel = n;
    }

    public int getLevel() {
        return this.theLevel;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.add);
        stringBuffer.append(": [");
        boolean bl = true;
        for (String string : this.choiceList) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string);
            bl = false;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public boolean testApply(Kit kit, PlayerCharacter playerCharacter, List<String> list) {
        return this.doApplication(playerCharacter);
    }

    @Override
    public void apply(PlayerCharacter playerCharacter) {
        this.doApplication(playerCharacter);
    }

    private boolean doApplication(PlayerCharacter playerCharacter) {
        List<PersistentTransitionChoice<?>> list;
        PCClass pCClass = this.theClassName.resolvesTo();
        PCClass pCClass2 = playerCharacter.getClassKeyed(pCClass.getKeyName());
        if (pCClass2 == null) {
            // empty if block
        }
        if ((list = pCClass.getListFor(ListKey.ADD)) == null) {
            // empty if block
        }
        for (PersistentTransitionChoice<?> persistentTransitionChoice : list) {
            if (!this.add.equals(persistentTransitionChoice)) continue;
            this.process(playerCharacter, pCClass2, persistentTransitionChoice);
            return true;
        }
        return false;
    }

    private <T> void process(PlayerCharacter playerCharacter, PCClass pCClass, PersistentTransitionChoice<T> persistentTransitionChoice) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (String string : this.choiceList) {
            arrayList.add(persistentTransitionChoice.decodeChoice(string));
        }
        persistentTransitionChoice.act(arrayList, pCClass, playerCharacter);
    }

    @Override
    public String getObjectName() {
        return "Class Feature";
    }

    public void addChoice(String string) {
        this.choiceList.add(string);
    }

    public void setAdd(PersistentTransitionChoice<?> persistentTransitionChoice) {
        this.add = persistentTransitionChoice;
    }

    public PersistentTransitionChoice<?> getAdd() {
        return this.add;
    }
}

