/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import pcgen.base.formula.Formula;
import pcgen.base.lang.StringUtil;
import pcgen.core.Kit;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PlayerCharacter;
import pcgen.core.StatList;
import pcgen.core.kit.BaseKit;
import pcgen.core.pclevelinfo.PCLevelInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KitStat
extends BaseKit {
    private Map<PCStat, Formula> statMap = new HashMap<PCStat, Formula>();
    private transient List<PCStat> theStat;

    public String toString() {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Map.Entry<PCStat, Formula> entry : this.statMap.entrySet()) {
            treeSet.add(entry.getKey().getAbb() + '=' + entry.getValue());
        }
        return StringUtil.join(treeSet, "|");
    }

    @Override
    public boolean testApply(Kit kit, PlayerCharacter playerCharacter, List<String> list) {
        this.theStat = new ArrayList<PCStat>();
        block0: for (Map.Entry<PCStat, Formula> entry : this.statMap.entrySet()) {
            int n = entry.getValue().resolve(playerCharacter, "").intValue();
            StatList statList = playerCharacter.getStatList();
            for (int i = 0; i < statList.size(); ++i) {
                PCStat pCStat = statList.getStatAt(i);
                if (playerCharacter.isNonAbility(i) || !pCStat.getAbb().equals(entry.getKey().getAbb())) continue;
                pCStat.setBaseScore(n);
                this.theStat.add(pCStat.clone());
                if (!"INT".equals(pCStat.getAbb())) continue block0;
                this.recalculateSkillPoints(playerCharacter);
                continue block0;
            }
        }
        return true;
    }

    @Override
    public void apply(PlayerCharacter playerCharacter) {
        StatList statList = playerCharacter.getStatList();
        block0: for (PCStat pCStat : statList) {
            for (PCStat pCStat2 : this.theStat) {
                if (!pCStat.getAbb().equals(pCStat2.getAbb())) continue;
                pCStat.setBaseScore(pCStat2.getBaseScore());
                if (!"INT".equals(pCStat.getAbb())) continue block0;
                this.recalculateSkillPoints(playerCharacter);
                continue block0;
            }
        }
    }

    @Override
    public String getObjectName() {
        return "Stats";
    }

    private void recalculateSkillPoints(PlayerCharacter playerCharacter) {
        ArrayList<PCClass> arrayList = playerCharacter.getClassList();
        playerCharacter.calcActiveBonuses();
        if (arrayList != null && arrayList.size() != 0) {
            playerCharacter.setSkillPoints(0);
            for (PCClass pCClass : arrayList) {
                pCClass.setSkillPool(0);
                if (playerCharacter.getLevelInfoSize() <= 0) continue;
                List<PCLevelInfo> list = playerCharacter.getLevelInfo();
                for (int i = 0; i < list.size(); ++i) {
                    PCLevelInfo pCLevelInfo = list.get(i);
                    if (!pCLevelInfo.getClassKeyName().equals(pCClass.getKeyName())) continue;
                    int n = pCClass.recalcSkillPointMod(playerCharacter, i + 1);
                    pCLevelInfo.setSkillPointsGained(n);
                    pCLevelInfo.setSkillPointsRemaining(pCLevelInfo.getSkillPointsGained());
                    pCClass.setSkillPool(pCClass.skillPool() + n);
                    playerCharacter.setSkillPoints(n + playerCharacter.getSkillPoints());
                }
            }
        }
    }

    public void addStat(PCStat pCStat, Formula formula) {
        if (this.statMap.put(pCStat, formula) != null) {
            throw new IllegalArgumentException("Cannot redefine stat: " + pCStat);
        }
    }

    public boolean isEmpty() {
        return this.statMap.isEmpty();
    }
}

