/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pcgen.base.lang.UnreachableError;
import pcgen.base.util.HashMapToList;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Kit;
import pcgen.core.PCTemplate;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.kit.BaseKit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KitTemplate
extends BaseKit {
    private HashMapToList<CDOMSingleRef<PCTemplate>, CDOMSingleRef<PCTemplate>> templateList = new HashMapToList();
    private transient HashMapToList<PCTemplate, PCTemplate> selectedMap = new HashMapToList();

    @Override
    public void apply(PlayerCharacter playerCharacter) {
        boolean bl = SettingsHandler.getShowHPDialogAtLevelUp();
        SettingsHandler.setShowHPDialogAtLevelUp(false);
        for (PCTemplate pCTemplate : this.selectedMap.getKeySet()) {
            List list = this.selectedMap.getListFor(pCTemplate);
            if (list != null) {
                for (PCTemplate pCTemplate2 : list) {
                    playerCharacter.setTemplatesAdded(pCTemplate, pCTemplate2);
                }
            }
            playerCharacter.addTemplate(pCTemplate, list == null || list.size() == 0);
        }
        SettingsHandler.setShowHPDialogAtLevelUp(bl);
    }

    @Override
    public boolean testApply(Kit kit, PlayerCharacter playerCharacter, List<String> list) {
        boolean bl = SettingsHandler.getShowHPDialogAtLevelUp();
        SettingsHandler.setShowHPDialogAtLevelUp(false);
        for (CDOMSingleRef cDOMSingleRef : this.templateList.getKeySet()) {
            Object object;
            PCTemplate pCTemplate;
            try {
                pCTemplate = ((PCTemplate)cDOMSingleRef.resolvesTo()).clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new UnreachableError("PCTemplate must support clone");
            }
            List list2 = this.templateList.getListFor(cDOMSingleRef);
            ArrayList<PCTemplate> arrayList = new ArrayList<PCTemplate>();
            if (list2 != null) {
                object = list2.iterator();
                while (object.hasNext()) {
                    PCTemplate pCTemplate2;
                    CDOMSingleRef cDOMSingleRef2 = (CDOMSingleRef)object.next();
                    try {
                        pCTemplate2 = ((PCTemplate)cDOMSingleRef2.resolvesTo()).clone();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        throw new UnreachableError("PCTemplate must support clone");
                    }
                    arrayList.add(pCTemplate2);
                    playerCharacter.setTemplatesAdded(pCTemplate, pCTemplate2);
                }
            }
            playerCharacter.addTemplate(pCTemplate, (object = playerCharacter.getTemplatesAdded(pCTemplate)) == null || object.size() == 0);
            this.selectedMap.initializeListFor(pCTemplate);
            this.selectedMap.addAllToListFor(pCTemplate, arrayList);
        }
        SettingsHandler.setShowHPDialogAtLevelUp(bl);
        return this.selectedMap.size() > 0;
    }

    @Override
    public String getObjectName() {
        return "Templates";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (CDOMSingleRef cDOMSingleRef : this.templateList.getKeySet()) {
            if (bl) {
                stringBuilder.append("|");
            }
            bl = true;
            stringBuilder.append(cDOMSingleRef.getLSTformat());
            List list = this.templateList.getListFor(cDOMSingleRef);
            if (list == null) continue;
            for (CDOMSingleRef cDOMSingleRef2 : list) {
                stringBuilder.append("[TEMPLATE:");
                stringBuilder.append(cDOMSingleRef2.getLSTformat());
                stringBuilder.append(']');
            }
        }
        return stringBuilder.toString();
    }

    public void addTemplate(CDOMSingleRef<PCTemplate> cDOMSingleRef, List<CDOMSingleRef<PCTemplate>> list) {
        this.templateList.initializeListFor(cDOMSingleRef);
        this.templateList.addAllToListFor(cDOMSingleRef, list);
    }

    public Collection<CDOMSingleRef<PCTemplate>> getTemplates() {
        return this.templateList.getKeySet();
    }

    public boolean isEmpty() {
        return this.templateList.isEmpty();
    }
}

