/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteOperator;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Prerequisite
implements Cloneable {
    public static final String CLEAR_KIND = "clear";
    public static final String APPLY_KIND = "APPLY";
    private String kind;
    private String key = null;
    private String subKey = null;
    private List<Prerequisite> prerequisites = new ArrayList<Prerequisite>();
    private PrerequisiteOperator operator = PrerequisiteOperator.GTEQ;
    private String operand = "1";
    private boolean totalValues;
    private boolean characterRequired = true;
    private boolean countMultiples;
    private boolean overrideQualify = false;
    private int levelQualifier = -1;
    private String categoryName;
    private boolean nativeCheckMult = false;

    public Prerequisite() {
    }

    public Prerequisite(Prerequisite prerequisite) {
        this.kind = prerequisite.kind;
        this.key = prerequisite.key;
        this.subKey = prerequisite.subKey;
        this.operator = prerequisite.operator;
        this.operand = prerequisite.operand;
        this.countMultiples = prerequisite.countMultiples;
        this.levelQualifier = prerequisite.levelQualifier;
        if (prerequisite.prerequisites != null) {
            for (Prerequisite prerequisite2 : prerequisite.prerequisites) {
                this.addPrerequisite(new Prerequisite(prerequisite2));
            }
        }
    }

    public final boolean isTotalValues() {
        return this.totalValues;
    }

    public final void setTotalValues(boolean bl) {
        this.totalValues = bl;
    }

    public void setCountMultiples(boolean bl) {
        this.countMultiples = bl;
    }

    public boolean isCountMultiples() {
        return this.countMultiples;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public String getKey() {
        return this.key;
    }

    public void setKind(String string) {
        this.kind = string;
    }

    public String getKind() {
        return this.kind;
    }

    public void setOperand(String string) {
        this.operand = string;
    }

    public String getOperand() {
        return this.operand;
    }

    public void setOperator(String string) throws PrerequisiteException {
        this.operator = PrerequisiteOperator.getOperatorByName(string);
    }

    public void setOperator(PrerequisiteOperator prerequisiteOperator) {
        this.operator = prerequisiteOperator;
    }

    public PrerequisiteOperator getOperator() {
        return this.operator;
    }

    public void setPrerequisites(List<Prerequisite> list) {
        this.prerequisites = list;
    }

    public void addPrerequisite(Prerequisite prerequisite) {
        this.prerequisites.add(prerequisite);
    }

    public List<Prerequisite> getPrerequisites() {
        return this.prerequisites;
    }

    public void setSubKey(String string) {
        this.subKey = string;
    }

    public String getSubKey() {
        return this.subKey;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(PropertyFactory.getString("Prerequisite.prereq_tag"));
        stringBuffer.append(" ");
        if (this.kind != null) {
            stringBuffer.append(PropertyFactory.getString("Prerequisite.kind"));
            stringBuffer.append("=\"");
            stringBuffer.append(this.kind);
            stringBuffer.append("\" ");
        }
        if (this.countMultiples) {
            stringBuffer.append(PropertyFactory.getString("Prerequisite.count-multiples"));
        }
        if (this.totalValues) {
            stringBuffer.append(PropertyFactory.getString("Prerequisite.total-values"));
        }
        if (this.categoryName != null) {
            stringBuffer.append(PropertyFactory.getString("Prerequisite.category"));
            stringBuffer.append("=\"");
            stringBuffer.append(this.categoryName);
            stringBuffer.append("\" ");
        }
        if (this.key != null) {
            stringBuffer.append(PropertyFactory.getString("Prerequisite.key"));
            stringBuffer.append("=\"");
            stringBuffer.append(this.key);
            stringBuffer.append("\" ");
        }
        if (this.subKey != null && !this.subKey.equals("")) {
            stringBuffer.append(PropertyFactory.getString("Prerequisite.sub-key"));
            stringBuffer.append("=\"");
            stringBuffer.append(this.subKey);
            stringBuffer.append("\" ");
        }
        stringBuffer.append(PropertyFactory.getString("Prerequisite.operator"));
        stringBuffer.append("=\"");
        stringBuffer.append(this.operator);
        stringBuffer.append("\" ");
        if (this.operand != null) {
            stringBuffer.append(PropertyFactory.getString("Prerequisite.operand"));
            stringBuffer.append("=\"");
            stringBuffer.append(this.operand);
            stringBuffer.append("\" ");
        }
        if (this.isOverrideQualify()) {
            stringBuffer.append(PropertyFactory.getString("Prerequisite.override-qualify"));
        }
        stringBuffer.append(">\n");
        if (this.prerequisites.size() > 0) {
            for (Prerequisite prerequisite : this.prerequisites) {
                stringBuffer.append(prerequisite.toString());
            }
        }
        stringBuffer.append("</");
        stringBuffer.append(PropertyFactory.getString("Prerequisite.prereq_tag"));
        stringBuffer.append(">\n");
        return stringBuffer.toString();
    }

    public boolean isOverrideQualify() {
        return this.overrideQualify;
    }

    public void setOverrideQualify(boolean bl) {
        this.overrideQualify = bl;
    }

    public Prerequisite clone() throws CloneNotSupportedException {
        Prerequisite prerequisite = (Prerequisite)super.clone();
        if (this.prerequisites != null) {
            prerequisite.prerequisites = new ArrayList<Prerequisite>();
            for (Prerequisite prerequisite2 : this.prerequisites) {
                prerequisite.prerequisites.add(prerequisite2.clone());
            }
        }
        return prerequisite;
    }

    public void expandToken(String string, String string2) {
        this.key = this.key.replaceAll(Pattern.quote(string), string2);
        this.operand = this.operand.replaceAll(Pattern.quote(string), string2);
        if (this.prerequisites != null) {
            for (Prerequisite prerequisite : this.prerequisites) {
                prerequisite.expandToken(string, string2);
            }
        }
    }

    public String getDescription(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.levelQualifier > 0 && !bl) {
            stringBuffer.append("at level ");
            stringBuffer.append(this.levelQualifier + ":");
            stringBuffer.append(' ');
        }
        if (this.categoryName != null && !bl) {
            stringBuffer.append("of category ");
            stringBuffer.append(this.categoryName + ":");
            stringBuffer.append(' ');
        }
        if (this.kind != null && !bl) {
            stringBuffer.append(this.kind);
            stringBuffer.append(' ');
        }
        if (this.key != null) {
            stringBuffer.append(this.key);
            if (!bl) {
                stringBuffer.append(' ');
            }
        }
        if (this.subKey != null && !this.subKey.equals("")) {
            stringBuffer.append('(');
            stringBuffer.append(this.subKey);
            stringBuffer.append(')');
            if (!bl) {
                stringBuffer.append(' ');
            }
        }
        if (!bl) {
            stringBuffer.append(this.operator);
            stringBuffer.append(' ');
        }
        if (this.operand != null && !bl) {
            stringBuffer.append(this.operand);
        }
        if (this.prerequisites.size() > 0 && !bl) {
            stringBuffer.append(" (");
            for (Prerequisite prerequisite : this.prerequisites) {
                stringBuffer.append(prerequisite.getDescription(bl));
            }
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public int getLevelQualifier() {
        return this.levelQualifier;
    }

    public void setLevelQualifier(int n) {
        this.levelQualifier = n;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String string) {
        this.categoryName = string;
    }

    public int hashCode() {
        return (this.kind == null ? -1 : this.kind.hashCode()) ^ (this.key == null ? 0 : this.key.hashCode());
    }

    public boolean equals(Object object) {
        boolean bl;
        if (object == this) {
            return true;
        }
        if (!(object instanceof Prerequisite)) {
            return false;
        }
        Prerequisite prerequisite = (Prerequisite)object;
        if (this.kind == null && prerequisite.kind != null) {
            return false;
        }
        if (this.key == null && prerequisite.key != null) {
            return false;
        }
        if (this.subKey == null && prerequisite.subKey != null) {
            return false;
        }
        if (this.categoryName == null && prerequisite.categoryName != null) {
            return false;
        }
        boolean bl2 = this.prerequisites != null && !this.prerequisites.isEmpty();
        boolean bl3 = bl = prerequisite.prerequisites != null && !prerequisite.prerequisites.isEmpty();
        if (bl2) {
            if (!bl) {
                return false;
            }
            List<Prerequisite> list = prerequisite.prerequisites;
            if (list.size() != this.prerequisites.size()) {
                return false;
            }
            ArrayList<Prerequisite> arrayList = new ArrayList<Prerequisite>(this.prerequisites);
            arrayList.removeAll(list);
            if (!arrayList.isEmpty()) {
                return false;
            }
        } else if (bl) {
            return false;
        }
        return !(this.countMultiples != prerequisite.countMultiples || this.overrideQualify != prerequisite.overrideQualify || this.levelQualifier != prerequisite.levelQualifier || this.operator != prerequisite.operator || this.kind != null && !this.kind.equals(prerequisite.kind) || this.key != null && !this.key.equals(prerequisite.key) || this.subKey != null && !this.subKey.equals(prerequisite.subKey) || !this.operand.equals(prerequisite.operand) || this.categoryName != null && !this.categoryName.equals(prerequisite.categoryName));
    }

    public boolean isCharacterRequired() {
        return this.characterRequired;
    }

    public void setCharacterRequired(boolean bl) {
        this.characterRequired = bl;
    }

    public void setOriginalCheckmult(boolean bl) {
        this.nativeCheckMult = bl;
    }

    public boolean isOriginalCheckMult() {
        return this.nativeCheckMult;
    }
}

