/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import java.util.HashMap;
import java.util.Map;
import pcgen.core.prereq.PreMult;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public class PrerequisiteTestFactory {
    private static PrerequisiteTestFactory instance = null;
    private static Map<String, PrerequisiteTest> testLookup = new HashMap<String, PrerequisiteTest>();

    public static PrerequisiteTestFactory getInstance() {
        if (instance == null) {
            instance = new PrerequisiteTestFactory();
        }
        return instance;
    }

    private PrerequisiteTestFactory() {
    }

    public static void register(PrerequisiteTest prerequisiteTest) {
        String string = prerequisiteTest.kindHandled();
        PrerequisiteTest prerequisiteTest2 = testLookup.get(string);
        if (prerequisiteTest2 != null) {
            Logging.errorPrint(PropertyFactory.getFormattedString("PrerequisiteTestFactory.error.already_registered", prerequisiteTest.getClass().getName(), string, prerequisiteTest2.getClass().getName()));
        }
        testLookup.put(string.toUpperCase(), prerequisiteTest);
    }

    public PrerequisiteTest getTest(String string) {
        PrerequisiteTest prerequisiteTest;
        if (string == null) {
            prerequisiteTest = new PreMult();
        } else {
            prerequisiteTest = testLookup.get(string.toUpperCase());
            if (prerequisiteTest == null) {
                Logging.errorPrintLocalised("PrerequisiteTestFactory.error.cannot_find_test", string);
            }
        }
        return prerequisiteTest;
    }
}

