/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.WeaponProf;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.spell.Spell;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrerequisiteUtilities {
    private PrerequisiteUtilities() {
    }

    public static final String preReqHTMLStringsForList(PlayerCharacter playerCharacter, PObject pObject, Collection<Prerequisite> collection, boolean bl) {
        if (collection == null || collection.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(collection.size() * 20);
        ArrayList<Prerequisite> arrayList = new ArrayList<Prerequisite>();
        int n = 0;
        for (Prerequisite prerequisite : collection) {
            arrayList.clear();
            arrayList.add(prerequisite);
            if (n++ > 0) {
                stringBuffer.append(" and ");
            }
            String string = PrereqHandler.toHtmlString(arrayList);
            boolean bl2 = pObject instanceof Equipment ? PrereqHandler.passesAll(arrayList, (Equipment)pObject, playerCharacter) : PrereqHandler.passesAll(arrayList, playerCharacter, null);
            if (!bl2) {
                stringBuffer.append(SettingsHandler.getPrereqFailColorAsHtmlStart());
                stringBuffer.append("<i>");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "&<>", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equals("<")) {
                    stringBuffer.append("&lt;");
                    continue;
                }
                if (string2.equals(">")) {
                    stringBuffer.append("&gt;");
                    continue;
                }
                if (string2.equals("&")) {
                    stringBuffer.append("&amp;");
                    continue;
                }
                stringBuffer.append(string2);
            }
            if (bl2) continue;
            stringBuffer.append("</i>");
            stringBuffer.append(SettingsHandler.getPrereqFailColorAsHtmlEnd());
        }
        if (stringBuffer.toString().indexOf(60) >= 0) {
            stringBuffer.insert(0, "<font>");
            stringBuffer.append("</font>");
            if (bl && stringBuffer.toString().indexOf(60) >= 0) {
                stringBuffer.insert(0, "<html>");
                stringBuffer.append("</html>");
            }
        }
        return stringBuffer.toString();
    }

    public static String getPrerequisitePCCText(List list, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (list != null && list.size() > 0) {
            StringWriter stringWriter = new StringWriter();
            PrerequisiteWriter prerequisiteWriter = new PrerequisiteWriter();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Prerequisite prerequisite = (Prerequisite)iterator.next();
                try {
                    prerequisiteWriter.write(stringWriter, prerequisite);
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    Logging.errorPrint("Failed to encode prereq: ", persistenceLayerException);
                }
                if (!iterator.hasNext()) continue;
                stringWriter.write(string);
            }
            stringBuffer.append(string);
            stringBuffer.append(stringWriter.toString());
        }
        return stringBuffer.toString();
    }

    public static int passesAbilityTest(Prerequisite prerequisite, PlayerCharacter playerCharacter, boolean bl, int n, String string, String string2, String string3, AbilityCategory abilityCategory) {
        boolean bl2;
        boolean bl3 = string.equalsIgnoreCase("ANY");
        boolean bl4 = string.startsWith("TYPE=") || string.startsWith("TYPE.");
        boolean bl5 = bl2 = string2 != null && (string2.startsWith("TYPE=") || string2.startsWith("TYPE."));
        if (bl4) {
            string = string.substring(5);
        }
        if (bl2) {
            string2 = string2.substring(5);
        }
        int n2 = 0;
        List<Ability> list = PrerequisiteUtilities.buildAbilityList(playerCharacter, string3, abilityCategory);
        if (!list.isEmpty()) {
            for (Ability ability : list) {
                String string4 = ability.getKeyName();
                if (bl3 || !bl4 && string4.equalsIgnoreCase(string) || bl4 && ability.isType(string)) {
                    if (string2 != null) {
                        n2 += PrerequisiteUtilities.checkForSubKeyMatch(playerCharacter, bl, string, string2, bl2, ability);
                        continue;
                    }
                    ++n2;
                    if (!ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue() || !bl) continue;
                    n2 += playerCharacter.getSelectCorrectedAssociationCount(ability) - 1;
                    continue;
                }
                if (string2 == null) continue;
                String string5 = string + " (" + string2 + ")";
                String string6 = string + "(" + string2 + ")";
                if (!string4.equalsIgnoreCase(string5) && !ability.getKeyName().equalsIgnoreCase(string6)) continue;
                ++n2;
                if (bl) continue;
                break;
            }
        }
        n2 = prerequisite.getOperator().compare(n2, n);
        return n2;
    }

    private static int checkForSubKeyMatch(PlayerCharacter playerCharacter, boolean bl, String string, String string2, boolean bl2, Ability ability) {
        int n;
        block4: {
            block7: {
                block2: {
                    String string3;
                    ArrayList<String> arrayList;
                    String string4;
                    block6: {
                        block5: {
                            block3: {
                                string4 = string2;
                                arrayList = new ArrayList<String>();
                                string3 = ability.getSafe(StringKey.CHOICE_STRING);
                                n = 0;
                                arrayList.addAll(playerCharacter.getAssociationList(ability));
                                if (!bl2) break block2;
                                if (!string3.startsWith("SKILL")) break block3;
                                n = PrerequisiteUtilities.subKeySkill(bl, n, string4, arrayList);
                                break block4;
                            }
                            if (!string3.startsWith("WEAPONPROFS")) break block5;
                            n = PrerequisiteUtilities.subKeyWeaponProf(bl, n, string4, arrayList);
                            break block4;
                        }
                        if (!string3.startsWith("DOMAIN")) break block6;
                        n = PrerequisiteUtilities.subKeyDomain(bl, n, string4, arrayList);
                        break block4;
                    }
                    if (!string3.startsWith("SPELL")) break block4;
                    n = PrerequisiteUtilities.subKeySpell(bl, n, string4, arrayList);
                    break block4;
                }
                if (!ability.getKeyName().equalsIgnoreCase(string) || !playerCharacter.containsAssociated((CDOMObject)ability, string2)) break block7;
                ++n;
                if (!ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue() || !bl) break block4;
                n += playerCharacter.getSelectCorrectedAssociationCount(ability) - 1;
                break block4;
            }
            int n2 = string2.indexOf(37);
            if (n2 > -1) {
                for (String string5 : playerCharacter.getAssociationList(ability)) {
                    String string6 = string5.toUpperCase();
                    if (n2 != 0 && !string6.startsWith(string2.substring(0, n2 - 1).toUpperCase())) continue;
                    ++n;
                    if (bl) continue;
                    break;
                }
            }
        }
        return n;
    }

    private static List<Ability> buildAbilityList(PlayerCharacter playerCharacter, String string, AbilityCategory abilityCategory) {
        ArrayList<Ability> arrayList = new ArrayList<Ability>();
        if (playerCharacter != null) {
            Collection<AbilityCategory> collection = SettingsHandler.getGame().getAllAbilityCategories();
            if (string == null) {
                for (AbilityCategory abilityCategory2 : collection) {
                    arrayList.addAll(playerCharacter.getAggregateAbilityList(abilityCategory2));
                }
            } else {
                for (AbilityCategory abilityCategory2 : collection) {
                    if (!abilityCategory2.getAbilityCategory().equalsIgnoreCase(string)) continue;
                    arrayList.addAll(playerCharacter.getAggregateAbilityList(abilityCategory2));
                }
            }
            for (AbilityCategory abilityCategory2 : collection) {
                for (Ability ability : playerCharacter.getAggregateAbilityList(abilityCategory2)) {
                    for (CDOMReference<Ability> cDOMReference : ability.getSafeListFor(ListKey.SERVES_AS_ABILITY)) {
                        for (Ability ability2 : cDOMReference.getContainedObjects()) {
                            if (string != null && !string.equals(ability2.getCategory())) continue;
                            arrayList.add(ability2);
                        }
                    }
                }
            }
        }
        return arrayList;
    }

    private static int subKeySpell(boolean bl, int n, String string, List list) {
        int n2 = n;
        for (Object e : list) {
            String string2 = null;
            string2 = e instanceof PObject ? ((PObject)e).getKeyName() : e.toString();
            Spell spell = Globals.getSpellKeyed(string2);
            if (spell == null || !spell.isType(string)) continue;
            ++n2;
            if (bl) continue;
            break;
        }
        return n2;
    }

    private static int subKeyDomain(boolean bl, int n, String string, List list) {
        int n2 = n;
        for (Object e : list) {
            Domain domain = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Domain.class, e.toString());
            if (domain == null || !domain.isType(string)) continue;
            ++n2;
            if (bl) continue;
            break;
        }
        return n2;
    }

    private static int subKeyWeaponProf(boolean bl, int n, String string, List list) {
        int n2 = n;
        for (Object e : list) {
            Equipment equipment;
            WeaponProf weaponProf = Globals.getContext().ref.silentlyGetConstructedCDOMObject(WeaponProf.class, e.toString());
            if (weaponProf == null || (equipment = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Equipment.class, weaponProf.getKeyName())) == null || !equipment.isType(string)) continue;
            ++n2;
            if (bl) continue;
            break;
        }
        return n2;
    }

    private static int subKeySkill(boolean bl, int n, String string, List list) {
        int n2 = n;
        for (Object e : list) {
            Skill skill = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Skill.class, e.toString());
            if (skill == null || !skill.isType(string)) continue;
            ++n2;
            if (bl) continue;
            break;
        }
        return n2;
    }

    public static final boolean hasPreReqKindOf(Prerequisite prerequisite, String string) {
        if (prerequisite == null) {
            return false;
        }
        if (string == null && prerequisite.getKind() == null) {
            return true;
        }
        if (string.equalsIgnoreCase(prerequisite.getKind())) {
            return true;
        }
        for (Prerequisite prerequisite2 : prerequisite.getPrerequisites()) {
            if (!PrerequisiteUtilities.hasPreReqKindOf(prerequisite2, string)) continue;
            return true;
        }
        return false;
    }

    public static final boolean hasPreReqMatching(Prerequisite prerequisite, String string, String string2) {
        if (prerequisite == null) {
            return false;
        }
        if ((string == null && prerequisite.getKind() == null || string.equalsIgnoreCase(prerequisite.getKind())) && (string2 == null && prerequisite.getKey() == null || string2.equalsIgnoreCase(prerequisite.getKey()))) {
            return true;
        }
        for (Prerequisite prerequisite2 : prerequisite.getPrerequisites()) {
            if (!PrerequisiteUtilities.hasPreReqMatching(prerequisite2, string, string2)) continue;
            return true;
        }
        return false;
    }
}

