/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.term;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pcgen.core.Equipment;
import pcgen.core.EquipmentUtilities;
import pcgen.core.PlayerCharacter;
import pcgen.core.term.BasePCTermEvaluator;
import pcgen.core.term.TermEvaluator;

public class PCCountEqTypeTermEvaluator
extends BasePCTermEvaluator
implements TermEvaluator {
    final String[] types;
    private final int merge;

    public PCCountEqTypeTermEvaluator(String string, String[] stringArray, int n) {
        this.originalText = string;
        this.types = stringArray;
        this.merge = n;
    }

    public Float resolve(PlayerCharacter playerCharacter) {
        Object object;
        List<Object> list = new ArrayList();
        int n = 0;
        String string = this.types[n];
        if ("CONTAINER".equals(string)) {
            ++n;
            object = playerCharacter.getEquipmentListInOutputOrder(this.merge);
            Iterator<Equipment> iterator = object.iterator();
            while (iterator.hasNext()) {
                Equipment equipment = iterator.next();
                if (!equipment.acceptsChildren()) continue;
                list.add(equipment);
            }
        } else if ("WEAPON".equalsIgnoreCase(string)) {
            ++n;
            list = playerCharacter.getExpandedWeapons(this.merge);
        } else if ("ACITEM".equalsIgnoreCase(string)) {
            ++n;
            object = playerCharacter.getEquipmentListInOutputOrder(this.merge);
            Iterator<Equipment> iterator = object.iterator();
            while (iterator.hasNext()) {
                Equipment equipment = iterator.next();
                if (!equipment.hasBonusWithInfo(playerCharacter, "AC") || equipment.isArmor() || equipment.isShield()) continue;
                list.add(equipment);
            }
        } else if ("".equalsIgnoreCase(string)) {
            ++n;
            list = playerCharacter.getEquipmentOfTypeInOutputOrder(string, 3, this.merge);
        } else {
            list = playerCharacter.getEquipmentOfTypeInOutputOrder(string, 3, this.merge);
        }
        while (n < this.types.length) {
            object = this.types[n];
            ++n;
            if ("NOT".equalsIgnoreCase((String)object)) {
                list = EquipmentUtilities.removeEqType(list, this.types[n]);
                ++n;
                continue;
            }
            if ("ADD".equalsIgnoreCase((String)object)) {
                list = playerCharacter.addEqType(list, this.types[n]);
                ++n;
                continue;
            }
            if ("IS".equalsIgnoreCase((String)object)) {
                list = EquipmentUtilities.removeNotEqType(list, this.types[n]);
                ++n;
                continue;
            }
            if (!"EQUIPPED".equalsIgnoreCase((String)object) && !"NOTEQUIPPED".equalsIgnoreCase((String)object)) continue;
            boolean bl = "EQUIPPED".equalsIgnoreCase((String)object);
            for (int i = list.size() - 1; i >= 0; --i) {
                Equipment equipment = (Equipment)list.get(i);
                if (equipment.isEquipped() == bl) continue;
                list.remove(equipment);
            }
        }
        return Float.valueOf(list.size());
    }

    public boolean isSourceDependant() {
        return false;
    }

    public boolean isStatic() {
        return false;
    }
}

