/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.PToolBar;
import pcgen.gui.filter.FilterAdapterPanel;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.filter.Filterable;
import pcgen.gui.tabs.InfoAbilities;
import pcgen.gui.tabs.InfoCharacterSheet;
import pcgen.gui.tabs.InfoClasses;
import pcgen.gui.tabs.InfoDescription;
import pcgen.gui.tabs.InfoDomain;
import pcgen.gui.tabs.InfoInventory;
import pcgen.gui.tabs.InfoRace;
import pcgen.gui.tabs.InfoSkills;
import pcgen.gui.tabs.InfoSpecialAbilities;
import pcgen.gui.tabs.InfoSpells;
import pcgen.gui.tabs.InfoSummary;
import pcgen.gui.utils.IconUtilitities;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CharacterInfo
extends JPanel {
    private List<Component> tempTabList;
    private List<CharacterInfoTab> tabList = new ArrayList<CharacterInfoTab>(12);
    private BorderLayout borderLayout1 = new BorderLayout();
    private InfoDescription infoDesc;
    private InfoInventory infoInventory;
    private InfoSummary infoSummary;
    private InfoRace infoRace;
    private InfoSpecialAbilities infoSpecialAbilities;
    private InfoClasses infoClasses;
    private InfoSkills infoSkills;
    private InfoAbilities infoAbilities;
    private InfoDomain infoDomain;
    private InfoSpells infoSpells;
    private InfoCharacterSheet infoCharacterSheet;
    private JTabbedPane characterInfoTabbedPane = new JTabbedPane();
    private PlayerCharacter pc;
    private static Set<CharacterInfoTab> updateSet = new HashSet<CharacterInfoTab>();
    private boolean refresh = false;

    public CharacterInfo(PlayerCharacter playerCharacter, List<Component> list) {
        this.pc = playerCharacter;
        this.tempTabList = list;
        this.infoDesc = new InfoDescription(this.pc);
        this.infoInventory = new InfoInventory(this.pc);
        this.infoSummary = new InfoSummary(this.pc);
        this.infoRace = new InfoRace(this.pc);
        this.infoSpecialAbilities = new InfoSpecialAbilities(this.pc);
        this.infoClasses = new InfoClasses(this.pc);
        this.infoSkills = new InfoSkills(this.pc);
        this.infoAbilities = new InfoAbilities(this.pc);
        this.infoDomain = new InfoDomain(this.pc);
        this.infoSpells = new InfoSpells(this.pc);
        this.infoCharacterSheet = new InfoCharacterSheet(this.pc);
        this.setName("");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logging.errorPrint(PropertyFactory.getString("in_CIerrorMess"), exception);
        }
    }

    private void addListeners() {
        this.characterInfoTabbedPane.addChangeListener(new tabChangeListener());
        ComponentListener componentListener = PToolBar.getCurrentInstance().getComponentListener();
        this.addComponentListener(componentListener);
        for (int i = 0; i < this.tabList.size(); ++i) {
            CharacterInfoTab characterInfoTab = this.tabList.get(i);
            if (!characterInfoTab.isShown() || !(characterInfoTab instanceof FilterAdapterPanel)) continue;
            FilterAdapterPanel filterAdapterPanel = (FilterAdapterPanel)((Object)characterInfoTab);
            filterAdapterPanel.addComponentListener(componentListener);
        }
        this.infoInventory.getInfoGear().addComponentListener(componentListener);
    }

    public void setRefresh(boolean bl) {
        this.refresh = bl;
    }

    public final Component getActivePane() {
        return this.characterInfoTabbedPane.getSelectedComponent();
    }

    public Filterable getSelectedFilterable() {
        Component component = this.characterInfoTabbedPane.getSelectedComponent();
        if (component instanceof Filterable) {
            return (Filterable)((Object)component);
        }
        return null;
    }

    public int getSelectedIndex() {
        return this.characterInfoTabbedPane.getSelectedIndex();
    }

    public void setTxtName(String string) {
        this.infoSummary.getPcNameText().setText(string);
        this.infoDesc.getTxtName().setText(string);
        this.refreshToDosAsync();
    }

    public int indexOfTab(String string) {
        int n = this.characterInfoTabbedPane.indexOfTab(string);
        return n;
    }

    public void refreshCharInfoTabs() {
        for (int i = 0; i < this.characterInfoTabbedPane.getTabCount(); ++i) {
            CharacterInfoTab characterInfoTab = (CharacterInfoTab)((Object)this.characterInfoTabbedPane.getComponentAt(i));
            this.characterInfoTabbedPane.setTitleAt(i, characterInfoTab.getTabName());
        }
        this.infoAbilities().refreshAbilityCategories();
    }

    public InfoDescription infoDesc() {
        return this.infoDesc;
    }

    public InfoInventory infoInventory() {
        return this.infoInventory;
    }

    public InfoSummary infoSummary() {
        return this.infoSummary;
    }

    public InfoRace infoRace() {
        return this.infoRace;
    }

    public InfoSpecialAbilities infoSpecialAbilities() {
        return this.infoSpecialAbilities;
    }

    public InfoClasses infoClasses() {
        return this.infoClasses;
    }

    public InfoCharacterSheet infoCharacterSheet() {
        return this.infoCharacterSheet;
    }

    public InfoSkills infoSkills() {
        return this.infoSkills;
    }

    public InfoAbilities infoAbilities() {
        return this.infoAbilities;
    }

    public InfoDomain infoDomain() {
        return this.infoDomain;
    }

    public InfoSpells infoSpells() {
        return this.infoSpells;
    }

    public void setPaneForUpdate(CharacterInfoTab characterInfoTab) {
        updateSet.add(characterInfoTab);
    }

    public void resetToSummaryTab() {
        this.characterInfoTabbedPane.setSelectedIndex(0);
    }

    public void restoreFilterSettings(String string) {
        if (string == null) {
            this.restoreAllFilterSettings();
            return;
        }
        for (int i = 0; i < this.characterInfoTabbedPane.getTabCount(); ++i) {
            Component component = this.characterInfoTabbedPane.getComponentAt(i);
            if (!(component instanceof Filterable) || component.getName() == null || !component.getName().equals(string)) continue;
            FilterFactory.restoreFilterSettings((Filterable)((Object)component));
        }
    }

    public void storeFilterSettings() {
        for (int i = 0; i < this.tabList.size(); ++i) {
            CharacterInfoTab characterInfoTab = this.tabList.get(i);
            if (!characterInfoTab.isShown() || !(characterInfoTab instanceof FilterAdapterPanel)) continue;
            FilterAdapterPanel filterAdapterPanel = (FilterAdapterPanel)((Object)characterInfoTab);
            SettingsHandler.storeFilterSettings(filterAdapterPanel);
        }
        SettingsHandler.storeFilterSettings(this.infoInventory.getInfoGear());
    }

    public void addTab(CharacterInfoTab characterInfoTab) {
        if (characterInfoTab.isShown()) {
            this.characterInfoTabbedPane.add((Component)characterInfoTab.getView(), characterInfoTab.getTabName());
        }
        this.tabList.add(characterInfoTab);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.characterInfoTabbedPane.setPreferredSize(new Dimension(550, 350));
        this.setMinimumSize(new Dimension(550, 350));
        this.setPreferredSize(new Dimension(550, 350));
        this.add((Component)this.characterInfoTabbedPane, "Center");
        this.characterInfoTabbedPane.setTabPlacement(SettingsHandler.getChaTabPlacement());
        this.addTab(this.infoSummary());
        this.addTab(this.infoRace());
        this.addTab(this.infoSpecialAbilities());
        this.addTab(this.infoClasses());
        this.addTab(this.infoSkills());
        this.addTab(this.infoAbilities());
        this.addTab(this.infoDomain());
        this.addTab(this.infoSpells());
        this.addTab(this.infoInventory());
        this.addTab(this.infoDesc());
        this.addTab(this.infoCharacterSheet);
        for (int i = 0; i < this.tempTabList.size(); ++i) {
            CharacterInfoTab characterInfoTab = (CharacterInfoTab)((Object)this.tempTabList.get(i));
            this.addTab(characterInfoTab);
        }
        this.addListeners();
    }

    private void restoreAllFilterSettings() {
        FilterFactory.clearFilterCache();
        for (int i = 0; i < this.tabList.size(); ++i) {
            CharacterInfoTab characterInfoTab = this.tabList.get(i);
            if (!characterInfoTab.isShown() || !(characterInfoTab instanceof FilterAdapterPanel)) continue;
            FilterAdapterPanel filterAdapterPanel = (FilterAdapterPanel)((Object)characterInfoTab);
            FilterFactory.restoreFilterSettings(filterAdapterPanel);
        }
        FilterFactory.restoreFilterSettings(this.infoInventory.getInfoGear());
    }

    public void refresh() {
        new Refresher().start();
    }

    public void setPc(PlayerCharacter playerCharacter) {
        this.pc = playerCharacter;
        CharacterInfoTab characterInfoTab = (CharacterInfoTab)((Object)this.characterInfoTabbedPane.getSelectedComponent());
        characterInfoTab.setPc(playerCharacter);
        new PcSetter().start();
    }

    protected PlayerCharacter getCurrentPC() {
        return this.pc;
    }

    public void refreshToDosAsync() {
        new ToDoRefresher().start();
    }

    private void flagToDos() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.tabList.size(); ++i) {
            CharacterInfoTab characterInfoTab = this.tabList.get(i);
            if (characterInfoTab.isShown()) {
                List<String> list = characterInfoTab.getToDos();
                arrayList.addAll(list);
                if (list.isEmpty()) {
                    this.characterInfoTabbedPane.setIconAt(this.indexOfTab(characterInfoTab.getTabName()), null);
                } else {
                    this.characterInfoTabbedPane.setIconAt(this.indexOfTab(characterInfoTab.getTabName()), IconUtilitities.getImageIcon("Checklist16.gif"));
                }
            }
            this.infoSummary.setToDoList(arrayList);
        }
    }

    private class ToDoRefresher
    extends SwingWorker {
        private ToDoRefresher() {
        }

        public Object construct() {
            return "";
        }

        public void finished() {
            CharacterInfo.this.flagToDos();
        }
    }

    private class Refresher
    extends SwingWorker {
        private Refresher() {
        }

        public Object construct() {
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            if (CharacterInfo.this.refresh) {
                CharacterInfoTab characterInfoTab = (CharacterInfoTab)((Object)CharacterInfo.this.characterInfoTabbedPane.getSelectedComponent());
                Set set = updateSet;
                synchronized (set) {
                    if (updateSet.contains(characterInfoTab)) {
                        characterInfoTab.refresh();
                        updateSet.remove(characterInfoTab);
                    }
                    Iterator iterator = updateSet.iterator();
                    while (iterator.hasNext()) {
                        characterInfoTab = (CharacterInfoTab)iterator.next();
                        if (characterInfoTab.isShown()) {
                            try {
                                characterInfoTab.refresh();
                            }
                            catch (Exception exception) {
                                System.out.println(exception.getMessage());
                                exception.printStackTrace();
                            }
                        }
                        iterator.remove();
                    }
                }
            }
        }
    }

    private class PcSetter
    extends SwingWorker {
        private PcSetter() {
        }

        public Object construct() {
            return "";
        }

        public void finished() {
            for (int i = 0; i < CharacterInfo.this.tabList.size(); ++i) {
                CharacterInfoTab characterInfoTab = (CharacterInfoTab)CharacterInfo.this.tabList.get(i);
                if (!characterInfoTab.isShown()) continue;
                characterInfoTab.setPc(CharacterInfo.this.pc);
            }
            CharacterInfo.this.flagToDos();
            PCGen_Frame1.getInst().repaint();
        }
    }

    private class tabChangeListener
    implements ChangeListener {
        private tabChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            CharacterInfoTab characterInfoTab = (CharacterInfoTab)((Object)CharacterInfo.this.characterInfoTabbedPane.getSelectedComponent());
            characterInfoTab.refresh();
            CharacterInfo.this.flagToDos();
        }
    }
}

